/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.mixin.rope;

import com.google.common.collect.Lists;
import dev.architectury.networking.NetworkManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.satisfy.brewery.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.util.rope.RopeConnection;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public class ChunkMapMixin {
    @Unique
    private ServerPlayer brewery$serverPlayer;
    @Unique
    private LevelChunk brewery$levelChunk;

    public ChunkMapMixin(LevelChunk levelChunk) {
        this.brewery$levelChunk = levelChunk;
    }

    @Inject(method={"playerLoadedChunk"}, at={@At(value="HEAD")})
    private void sendAttachChainPackets(ServerPlayer serverPlayer, MutableObject<ClientboundLevelChunkWithLightPacket> mutableObject, LevelChunk levelChunk, CallbackInfo ci) {
        this.brewery$serverPlayer = serverPlayer;
        this.brewery$levelChunk = levelChunk;
    }

    @Redirect(method={"playerLoadedChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;chunkPosition()Lnet/minecraft/world/level/ChunkPos;"))
    private ChunkPos sendAttachChainPackets(Entity entity) {
        RopeKnotEntity knot;
        ArrayList knots = Lists.newArrayList();
        if (entity.m_146902_().equals((Object)this.brewery$levelChunk.m_7697_()) && entity instanceof RopeKnotEntity && !(knot = (RopeKnotEntity)entity).getConnections().isEmpty()) {
            knots.add(knot);
        }
        for (RopeKnotEntity knot2 : knots) {
            FriendlyByteBuf buf = BreweryNetworking.createPacketBuf();
            Set<RopeConnection> connections = knot2.getConnections();
            IntArrayList ids = new IntArrayList(connections.size());
            for (RopeConnection connection : connections) {
                if (connection.from() != knot2) continue;
                ids.add(connection.to().m_19879_());
            }
            if (ids.isEmpty()) continue;
            buf.writeInt(knot2.m_19879_());
            buf.m_178345_((IntList)ids);
            NetworkManager.sendToPlayer((ServerPlayer)this.brewery$serverPlayer, (ResourceLocation)BreweryNetworking.SYNC_ROPE_S2C_ID, (FriendlyByteBuf)buf);
        }
        return entity.m_146902_();
    }
}

