/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.satisfy.brewery.entity.BeerElementalAttackEntity;
import net.satisfy.brewery.entity.BeerElementalEntity;
import net.satisfy.brewery.entity.rope.HangingRopeEntity;
import net.satisfy.brewery.entity.rope.RopeCollisionEntity;
import net.satisfy.brewery.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.util.BreweryIdentifier;

public class EntityRegistry {
    private static final Registrar<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256939_).getRegistrar();
    public static final RegistrySupplier<EntityType<RopeKnotEntity>> ROPE_KNOT = EntityRegistry.create("rope_knot", () -> EntityType.Builder.m_20704_(RopeKnotEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.375f, 0.25f).m_20702_(20).m_20720_().m_20719_().m_20712_(new BreweryIdentifier("rope_knot").toString()));
    public static final RegistrySupplier<EntityType<RopeCollisionEntity>> ROPE_COLLISION = EntityRegistry.create("rope_collision", () -> EntityType.Builder.m_20704_(RopeCollisionEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(10).m_20716_().m_20698_().m_20719_().m_20712_(new BreweryIdentifier("rope_collision").toString()));
    public static final RegistrySupplier<EntityType<HangingRopeEntity>> HANGING_ROPE = EntityRegistry.create("hanging_rope", () -> EntityType.Builder.m_20704_(HangingRopeEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(10).m_20716_().m_20698_().m_20719_().m_20712_(new BreweryIdentifier("hanging_rope").toString()));
    public static final RegistrySupplier<EntityType<BeerElementalEntity>> BEER_ELEMENTAL = EntityRegistry.create("beer_elemental", () -> EntityType.Builder.m_20704_(BeerElementalEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.6f).m_20702_(80).m_20717_(3).m_20712_(new BreweryIdentifier("beer_elemental").toString()));
    public static final RegistrySupplier<EntityType<BeerElementalAttackEntity>> BEER_ELEMENTAL_ATTACK = EntityRegistry.create("beer_elemental_attack", () -> EntityType.Builder.m_20704_(BeerElementalAttackEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(4).m_20717_(10).m_20712_(new BreweryIdentifier("beer_elemental_attack").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new BreweryIdentifier(path), type);
    }

    public static void registerBeerElemental() {
        EntityAttributeRegistry.register(BEER_ELEMENTAL, BeerElementalEntity::createAttributes);
    }

    public static void init() {
        EntityRegistry.registerBeerElemental();
    }
}

