/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.BenchBlock;
import de.cristelknight.doapi.common.block.CabinetBlock;
import de.cristelknight.doapi.common.block.CabinetWallBlock;
import de.cristelknight.doapi.common.block.FacingBlock;
import de.cristelknight.doapi.common.block.SideBoardBlock;
import de.cristelknight.doapi.common.block.WallDecorationBlock;
import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.BarCounterBlock;
import net.satisfy.brewery.block.BarleyCropBlock;
import net.satisfy.brewery.block.BeerKegFlowerPotBlock;
import net.satisfy.brewery.block.BeverageBlock;
import net.satisfy.brewery.block.CornCropBlock;
import net.satisfy.brewery.block.FoodBlock;
import net.satisfy.brewery.block.HangingRope;
import net.satisfy.brewery.block.HopsCropBodyBlock;
import net.satisfy.brewery.block.HopsCropHeadBlock;
import net.satisfy.brewery.block.SiloBlock;
import net.satisfy.brewery.block.TableBlock;
import net.satisfy.brewery.block.barrel.BigBarrelMainBlock;
import net.satisfy.brewery.block.barrel.BigBarrelMainHeadBlock;
import net.satisfy.brewery.block.barrel.BigBarrelRightBlock;
import net.satisfy.brewery.block.barrel.BigBarrelRightHeadBlock;
import net.satisfy.brewery.block.brewingstation.BrewKettleBlock;
import net.satisfy.brewery.block.brewingstation.BrewOvenBlock;
import net.satisfy.brewery.block.brewingstation.BrewTimerBlock;
import net.satisfy.brewery.block.brewingstation.BrewWhistleBlock;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.item.BeerStandardItem;
import net.satisfy.brewery.item.Breathalyzer;
import net.satisfy.brewery.item.BrewfestBoots;
import net.satisfy.brewery.item.BrewfestChest;
import net.satisfy.brewery.item.BrewfestHatItem;
import net.satisfy.brewery.item.BrewfestHatRedItem;
import net.satisfy.brewery.item.BrewfestLegs;
import net.satisfy.brewery.item.DrinkBlockItem;
import net.satisfy.brewery.item.RopeItem;
import net.satisfy.brewery.item.SaturatedBlockItem;
import net.satisfy.brewery.item.SaturatedItem;
import net.satisfy.brewery.registry.ArmorMaterialRegistry;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.MobEffectRegistry;
import net.satisfy.brewery.util.BreweryFoodProperties;
import net.satisfy.brewery.util.BreweryIdentifier;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> WILD_HOPS = ObjectRegistry.registerWithoutItem("wild_hops", () -> new TallFlowerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50357_)));
    public static final RegistrySupplier<Block> HOPS_CROP = ObjectRegistry.registerWithoutItem("hops_crop", () -> new HopsCropHeadBlock(ObjectRegistry.getBushSettings().m_60977_()));
    public static final RegistrySupplier<Block> HOPS_CROP_BODY = ObjectRegistry.registerWithoutItem("hops_crop_body", () -> new HopsCropBodyBlock(ObjectRegistry.getBushSettings().m_60977_()));
    public static final RegistrySupplier<Item> HOPS_SEEDS = ObjectRegistry.registerItem("hops_seeds", () -> new BlockItem((Block)HOPS_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> HOPS = ObjectRegistry.registerItem("hops", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38810_)));
    public static final RegistrySupplier<Block> BARLEY_CROP = ObjectRegistry.registerWithoutItem("barley_crop", () -> new BarleyCropBlock(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<Item> BARLEY_SEEDS = ObjectRegistry.registerItem("barley_seeds", () -> new BlockItem((Block)BARLEY_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BARLEY = ObjectRegistry.registerItem("barley", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38810_)));
    public static final RegistrySupplier<Block> CORN_CROP = ObjectRegistry.registerWithoutItem("corn_crop", () -> new CornCropBlock(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<Item> CORN_SEEDS = ObjectRegistry.registerItem("corn_seeds", () -> new BlockItem((Block)CORN_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> CORN = ObjectRegistry.registerItem("corn", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38810_)));
    public static final RegistrySupplier<Block> DRIED_WHEAT = ObjectRegistry.registerWithItem("dried_wheat", () -> new FacingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50335_)));
    public static final RegistrySupplier<Block> DRIED_BARLEY = ObjectRegistry.registerWithItem("dried_barley", () -> new FacingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50335_)));
    public static final RegistrySupplier<Block> DRIED_CORN = ObjectRegistry.registerWithItem("dried_corn", () -> new FacingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50335_)));
    public static final RegistrySupplier<Block> BENCH = ObjectRegistry.registerWithItem("bench", () -> new BenchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> TABLE = ObjectRegistry.registerWithItem("table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> PATTERNED_WOOL = ObjectRegistry.registerWithItem("patterned_wool", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50109_)));
    public static final RegistrySupplier<Block> PATTERNED_CARPET = ObjectRegistry.registerWithItem("patterned_carpet", () -> new CarpetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50351_)));
    public static final RegistrySupplier<Block> CABINET = ObjectRegistry.registerWithItem("cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (Supplier)DoApiSoundEventRegistry.CABINET_OPEN, (Supplier)DoApiSoundEventRegistry.CABINET_CLOSE));
    public static final RegistrySupplier<Block> DRAWER = ObjectRegistry.registerWithItem("drawer", () -> new CabinetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (Supplier)DoApiSoundEventRegistry.DRAWER_OPEN, (Supplier)DoApiSoundEventRegistry.DRAWER_CLOSE));
    public static final RegistrySupplier<Block> BAR_COUNTER = ObjectRegistry.registerWithItem("bar_counter", () -> new BarCounterBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> SIDEBOARD = ObjectRegistry.registerWithItem("sideboard", () -> new SideBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> WALL_CABINET = ObjectRegistry.registerWithItem("wall_cabinet", () -> new CabinetWallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), DoApiSoundEventRegistry.CABINET_OPEN, DoApiSoundEventRegistry.CABINET_CLOSE));
    public static final RegistrySupplier<Item> BREATHALYZER = ObjectRegistry.registerItem("breathalyzer", () -> new Breathalyzer(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> WOODEN_BREWINGSTATION = ObjectRegistry.registerWithItem("wooden_brewingstation", () -> new BrewKettleBlock(BrewMaterial.WOOD, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> COPPER_BREWINGSTATION = ObjectRegistry.registerWithItem("copper_brewingstation", () -> new BrewKettleBlock(BrewMaterial.COPPER, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> NETHERITE_BREWINGSTATION = ObjectRegistry.registerWithItem("netherite_brewingstation", () -> new BrewKettleBlock(BrewMaterial.NETHERITE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> BREW_WHISTLE = ObjectRegistry.registerWithoutItem("brew_whistle", () -> new BrewWhistleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> BREW_OVEN = ObjectRegistry.registerWithoutItem("brew_oven", () -> new BrewOvenBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> BREW_TIMER = ObjectRegistry.registerWithoutItem("brew_timer", () -> new BrewTimerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> SILO_WOOD = ObjectRegistry.registerWithItem("silo_wood", () -> new SiloBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_().m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> SILO_COPPER = ObjectRegistry.registerWithItem("silo_copper", () -> new SiloBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_60955_().m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> BARREL_MAIN = ObjectRegistry.registerWithItem("barrel_main", () -> new BigBarrelMainBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> BARREL_MAIN_HEAD = ObjectRegistry.registerWithoutItem("barrel_main_head", () -> new BigBarrelMainHeadBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278166_(PushReaction.IGNORE).m_222994_()));
    public static final RegistrySupplier<Block> BARREL_RIGHT = ObjectRegistry.registerWithoutItem("barrel_right", () -> new BigBarrelRightBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278166_(PushReaction.IGNORE).m_222994_()));
    public static final RegistrySupplier<Block> BARREL_HEAD_RIGHT = ObjectRegistry.registerWithoutItem("barrel_head_right", () -> new BigBarrelRightHeadBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278166_(PushReaction.IGNORE).m_222994_()));
    public static final RegistrySupplier<Item> ROPE = ObjectRegistry.registerItem("rope", () -> new RopeItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> HANGING_ROPE = ObjectRegistry.registerWithoutItem("hanging_rope", () -> new HangingRope(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50103_)));
    public static final RegistrySupplier<Block> BEER_MUG = ObjectRegistry.registerWithItem("beer_mug", () -> new BeerKegFlowerPotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistrySupplier<Block> BEER_WHEAT = ObjectRegistry.registerWithItemeverage("beer_wheat", () -> new BeverageBlock(ObjectRegistry.getMugSettings(), 2), MobEffectRegistry.SNOWWHITE, 600);
    public static final RegistrySupplier<Block> BEER_HOPS = ObjectRegistry.registerWithItemeverage("beer_hops", () -> new BeverageBlock(ObjectRegistry.getMugSettings(), 2), MobEffectRegistry.PARTYSTARTER, 600);
    public static final RegistrySupplier<Block> BEER_BARLEY = ObjectRegistry.registerWithItemeverage("beer_barley", () -> new BeverageBlock(ObjectRegistry.getMugSettings(), 2), MobEffectRegistry.PINTCHARISMA, 600);
    public static final RegistrySupplier<Block> BEER_HALEY = ObjectRegistry.registerWithItemeverage("beer_haley", () -> new BeverageBlock(ObjectRegistry.getMugSettings(), 2), MobEffectRegistry.HALEY, 600);
    public static final RegistrySupplier<Block> WHISKEY_MAGGOALLAN = ObjectRegistry.registerWithItemeverage("whiskey_maggoallan", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings(), 1), MobEffectRegistry.HEALINGTOUCH, 600);
    public static final RegistrySupplier<Block> WHISKEY_CARRASCONLABEL = ObjectRegistry.registerWithItemeverage("whiskey_carrasconlabel", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings(), 1), MobEffectRegistry.RENEWINGTOUCH, 600);
    public static final RegistrySupplier<Block> WHISKEY_LILITUSINGLEMALT = ObjectRegistry.registerWithItemeverage("whiskey_lilitusinglemalt", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings(), 1), MobEffectRegistry.PARTYSTARTER, 600);
    public static final RegistrySupplier<Block> WHISKEY_JOJANNIK = ObjectRegistry.registerWithItemeverage("whiskey_jojannik", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings(), 1), MobEffectRegistry.TOXICTOUCH, 600);
    public static final RegistrySupplier<Block> WHISKEY_CRISTELWALKER = ObjectRegistry.registerWithItemeverage("whiskey_cristelwalker", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings(), 3), MobEffectRegistry.PROTECTIVETOUCH, 600);
    public static final RegistrySupplier<Block> PORK_KNUCKLE_BLOCK = ObjectRegistry.registerWithoutItem("pork_knuckle", () -> new FoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 2, BreweryFoodProperties.PORK_KNUCKLE));
    public static final RegistrySupplier<Block> FRIED_CHICKEN_BLOCK = ObjectRegistry.registerWithoutItem("fried_chicken", () -> new FoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 1, BreweryFoodProperties.FRIED_CHICKEN));
    public static final RegistrySupplier<Block> HALF_CHICKEN_BLOCK = ObjectRegistry.registerWithoutItem("half_chicken", () -> new FoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 3, BreweryFoodProperties.HALF_CHICKEN));
    public static final RegistrySupplier<Block> MASHED_POTATOES_BLOCK = ObjectRegistry.registerWithoutItem("mashed_potatoes", () -> new FoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 1, BreweryFoodProperties.MASHED_POTATOES));
    public static final RegistrySupplier<Block> POTATO_SALAD_BLOCK = ObjectRegistry.registerWithoutItem("potato_salad", () -> new FoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 1, BreweryFoodProperties.POTATO_SALAD));
    public static final RegistrySupplier<Block> DUMPLINGS_BLOCK = ObjectRegistry.registerWithoutItem("dumplings", () -> new FoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 2, BreweryFoodProperties.POTATO_SALAD));
    public static final RegistrySupplier<Item> PORK_KNUCKLE = ObjectRegistry.registerItem("pork_knuckle", () -> new SaturatedBlockItem((Block)PORK_KNUCKLE_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (MobEffect)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<Item> FRIED_CHICKEN = ObjectRegistry.registerItem("fried_chicken", () -> new SaturatedBlockItem((Block)FRIED_CHICKEN_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (MobEffect)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<Item> HALF_CHICKEN = ObjectRegistry.registerItem("half_chicken", () -> new SaturatedBlockItem((Block)HALF_CHICKEN_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (MobEffect)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<Item> SAUSAGE = ObjectRegistry.registerItem("sausage", () -> new SaturatedItem(ObjectRegistry.getFoodItemSettings(8, 0.8f, (MobEffect)MobEffectRegistry.SATURATED.get(), 6000)));
    public static final RegistrySupplier<Item> MASHED_POTATOES = ObjectRegistry.registerItem("mashed_potatoes", () -> new SaturatedBlockItem((Block)MASHED_POTATOES_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (MobEffect)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<Item> POTATO_SALAD = ObjectRegistry.registerItem("potato_salad", () -> new SaturatedBlockItem((Block)POTATO_SALAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(7, 0.8f, (MobEffect)MobEffectRegistry.SATURATED.get(), 6000)));
    public static final RegistrySupplier<Item> DUMPLINGS = ObjectRegistry.registerItem("dumplings", () -> new SaturatedBlockItem((Block)DUMPLINGS_BLOCK.get(), ObjectRegistry.getFoodItemSettings(7, 0.8f, (MobEffect)MobEffectRegistry.SATURATED.get(), 6000)));
    public static final RegistrySupplier<Item> PRETZEL = ObjectRegistry.registerItem("pretzel", () -> new SaturatedItem(ObjectRegistry.getFoodItemSettings(4, 0.47f, (MobEffect)MobEffectRegistry.SATURATED.get(), 2000)));
    public static final RegistrySupplier<Block> GINGERBREAD = ObjectRegistry.registerWithItem("gingerbread", () -> new WallDecorationBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Item> BEER_ELEMENTAL_SPAWN_EGG = ObjectRegistry.registerItem("beer_elemental_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.BEER_ELEMENTAL, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BREWFEST_HAT = ObjectRegistry.registerItem("brewfest_hat", () -> new BrewfestHatItem(ObjectRegistry.getSettings().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> BREWFEST_REGALIA = ObjectRegistry.registerItem("brewfest_regalia", () -> new BrewfestChest(ArmorMaterialRegistry.BREWFEST_ARMOR, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> BREWFEST_TROUSERS = ObjectRegistry.registerItem("brewfest_trousers", () -> new BrewfestLegs(ArmorMaterialRegistry.BREWFEST_ARMOR, ObjectRegistry.getSettings().m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Item> BREWFEST_BOOTS = ObjectRegistry.registerItem("brewfest_boots", () -> new BrewfestBoots(ArmorMaterialRegistry.BREWFEST_ARMOR, ObjectRegistry.getSettings().m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Item> BREWFEST_HAT_RED = ObjectRegistry.registerItem("brewfest_hat_red", () -> new BrewfestHatRedItem(ObjectRegistry.getSettings().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> BREWFEST_DRESS = ObjectRegistry.registerItem("brewfest_dress", () -> new BrewfestLegs(ArmorMaterialRegistry.BREWFEST_DRESS, ObjectRegistry.getSettings().m_41497_(Rarity.RARE)));
    public static final RegistrySupplier<Item> BREWFEST_BLOUSE = ObjectRegistry.registerItem("brewfest_blouse", () -> new BrewfestChest(ArmorMaterialRegistry.BREWFEST_DRESS, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> BREWFEST_SHOES = ObjectRegistry.registerItem("brewfest_shoes", () -> new BrewfestBoots(ArmorMaterialRegistry.BREWFEST_DRESS, ObjectRegistry.getSettings().m_41497_(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> BEER_STANDARD = ObjectRegistry.registerItem("beer_standard", () -> new BeerStandardItem(new Item.Properties().m_41487_(16).m_41497_(Rarity.UNCOMMON)));
    public static final Map<Supplier<Item>, RegistrySupplier<Item>> SEEDCONVERSION = new HashMap<Supplier<Item>, RegistrySupplier<Item>>();

    public static void init() {
        Brewery.LOGGER.debug("register Mod Block and Items for brewery");
        ITEMS.register();
        BLOCKS.register();
    }

    public static void commonInit() {
        FuelRegistry.register((int)300, (ItemLike[])new ItemLike[]{(ItemLike)BEER_MUG.get(), (ItemLike)BENCH.get(), (ItemLike)TABLE.get(), (ItemLike)BAR_COUNTER.get(), (ItemLike)WOODEN_BREWINGSTATION.get()});
        FuelRegistry.register((int)100, (ItemLike[])new ItemLike[]{(ItemLike)CORN.get(), (ItemLike)BARLEY.get(), (ItemLike)HOPS.get()});
        FuelRegistry.register((int)75, (ItemLike[])new ItemLike[]{(ItemLike)PATTERNED_WOOL.get(), (ItemLike)PATTERNED_CARPET.get()});
        FuelRegistry.register((int)50, (ItemLike[])new ItemLike[]{(ItemLike)BREWFEST_BOOTS.get(), (ItemLike)BREWFEST_HAT.get(), (ItemLike)BREWFEST_DRESS.get(), (ItemLike)BREWFEST_REGALIA.get(), (ItemLike)BREWFEST_TROUSERS.get()});
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return ObjectRegistry.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.m_284310_().m_60913_(breakSpeed, explosionResist);
    }

    private static Item.Properties getSettingsWithoutTab(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, MobEffect effect, int duration) {
        return ObjectRegistry.getFoodItemSettings(nutrition, saturationMod, effect, duration, false, false);
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, MobEffect effect, int duration, boolean alwaysEat, boolean fast) {
        return ObjectRegistry.getSettings().m_41489_(ObjectRegistry.createFood(nutrition, saturationMod, effect, duration, alwaysEat, fast));
    }

    private static BlockBehaviour.Properties getBeverageSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60966_();
    }

    private static BlockBehaviour.Properties getMugSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60955_().m_60966_();
    }

    private static BlockBehaviour.Properties getBushSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_);
    }

    private static FoodProperties createFood(int nutrition, float saturationMod, MobEffect effect, int duration, boolean alwaysEat, boolean fast) {
        FoodProperties.Builder food = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturationMod);
        if (alwaysEat) {
            food.m_38765_();
        }
        if (fast) {
            food.m_38766_();
        }
        if (effect != null) {
            food.m_38762_(new MobEffectInstance(effect, duration), 1.0f);
        }
        return food.m_38767_();
    }

    private static <T extends Block> RegistrySupplier<T> registerWithItemeverage(String name, Supplier<T> block, RegistrySupplier<MobEffect> effect, int duration) {
        RegistrySupplier toReturn = ObjectRegistry.registerWithoutItem(name, block);
        ObjectRegistry.registerItem(name, () -> new DrinkBlockItem((MobEffect)effect.get(), duration, (Block)toReturn.get(), ObjectRegistry.getSettings(settings -> settings.m_41489_(ObjectRegistry.beverageFoodComponent()))));
        return toReturn;
    }

    private static FoodProperties beverageFoodComponent() {
        FoodProperties.Builder component = new FoodProperties.Builder().m_38760_(2).m_38758_(1.0f);
        return component.m_38767_();
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)new BreweryIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)new BreweryIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return Util.registerItem(ITEMS, ITEM_REGISTRAR, (ResourceLocation)new BreweryIdentifier(path), itemSupplier);
    }

    static {
        SEEDCONVERSION.put(() -> Items.f_42404_, CORN_SEEDS);
        SEEDCONVERSION.put(() -> Items.f_42733_, BARLEY_SEEDS);
        SEEDCONVERSION.put(() -> Items.f_42582_, HALF_CHICKEN);
        SEEDCONVERSION.put(() -> Items.f_42674_, MASHED_POTATOES);
    }
}

