/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.shapes;

import com.abdelaziz.canary.common.shapes.VoxelShapeCaster;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeSimpleCube
extends VoxelShape
implements VoxelShapeCaster {
    static final double EPSILON = 1.0E-7;
    final double minX;
    final double minY;
    final double minZ;
    final double maxX;
    final double maxY;
    final double maxZ;
    public final boolean isTiny;

    public VoxelShapeSimpleCube(DiscreteVoxelShape voxels, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(voxels);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.isTiny = this.minX + 3.0E-7 >= this.maxX || this.minY + 3.0E-7 >= this.maxY || this.minZ + 3.0E-7 >= this.maxZ;
    }

    public VoxelShape m_83216_(double x, double y, double z) {
        return new VoxelShapeSimpleCube(this.f_83211_, this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public double m_83245_(AxisCycle cycleDirection, AABB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisCycle dir, AABB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeSimpleCube.calculatePenetration(this.minX, this.maxX, box.f_82288_, box.f_82291_, maxDist);
            }
            case FORWARD: {
                return VoxelShapeSimpleCube.calculatePenetration(this.minZ, this.maxZ, box.f_82290_, box.f_82293_, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeSimpleCube.calculatePenetration(this.minY, this.maxY, box.f_82289_, box.f_82292_, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    boolean intersects(AxisCycle dir, AABB box) {
        switch (dir) {
            case NONE: {
                return VoxelShapeSimpleCube.lessThan(this.minY, box.f_82292_) && VoxelShapeSimpleCube.lessThan(box.f_82289_, this.maxY) && VoxelShapeSimpleCube.lessThan(this.minZ, box.f_82293_) && VoxelShapeSimpleCube.lessThan(box.f_82290_, this.maxZ);
            }
            case FORWARD: {
                return VoxelShapeSimpleCube.lessThan(this.minX, box.f_82291_) && VoxelShapeSimpleCube.lessThan(box.f_82288_, this.maxX) && VoxelShapeSimpleCube.lessThan(this.minY, box.f_82292_) && VoxelShapeSimpleCube.lessThan(box.f_82289_, this.maxY);
            }
            case BACKWARD: {
                return VoxelShapeSimpleCube.lessThan(this.minZ, box.f_82293_) && VoxelShapeSimpleCube.lessThan(box.f_82290_, this.maxZ) && VoxelShapeSimpleCube.lessThan(this.minX, box.f_82291_) && VoxelShapeSimpleCube.lessThan(box.f_82288_, this.maxX);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double a1, double a2, double b1, double b2, double maxDist) {
        double penetration;
        if (maxDist > 0.0 ? (penetration = a1 - b2) < -1.0E-7 || maxDist < penetration : (penetration = a2 - b1) > 1.0E-7 || maxDist > penetration) {
            return maxDist;
        }
        return penetration;
    }

    public List<AABB> m_83299_() {
        return Lists.newArrayList((Object[])new AABB[]{this.m_83215_()});
    }

    public AABB m_83215_() {
        return new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public double m_83288_(Direction.Axis axis) {
        return axis.m_6150_(this.minX, this.minY, this.minZ);
    }

    public double m_83297_(Direction.Axis axis) {
        return axis.m_6150_(this.maxX, this.maxY, this.maxZ);
    }

    protected double m_83256_(Direction.Axis axis, int index) {
        if (index < 0 || index > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        switch (axis) {
            case X: {
                return index == 0 ? this.minX : this.maxX;
            }
            case Y: {
                return index == 0 ? this.minY : this.maxY;
            }
            case Z: {
                return index == 0 ? this.minZ : this.maxZ;
            }
        }
        throw new IllegalArgumentException();
    }

    public DoubleList m_7700_(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return DoubleArrayList.wrap((double[])new double[]{this.minX, this.maxX});
            }
            case Y: {
                return DoubleArrayList.wrap((double[])new double[]{this.minY, this.maxY});
            }
            case Z: {
                return DoubleArrayList.wrap((double[])new double[]{this.minZ, this.maxZ});
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean m_83281_() {
        return this.minX >= this.maxX || this.minY >= this.maxY || this.minZ >= this.maxZ;
    }

    protected int m_6595_(Direction.Axis axis, double coord) {
        if (coord < this.m_83288_(axis)) {
            return -1;
        }
        if (coord >= this.m_83297_(axis)) {
            return 1;
        }
        return 0;
    }

    private static boolean lessThan(double a, double b) {
        return a + 1.0E-7 < b;
    }

    @Override
    public boolean intersects(AABB box, double blockX, double blockY, double blockZ) {
        return box.f_82288_ + 1.0E-7 < this.maxX + blockX && box.f_82291_ - 1.0E-7 > this.minX + blockX && box.f_82289_ + 1.0E-7 < this.maxY + blockY && box.f_82292_ - 1.0E-7 > this.minY + blockY && box.f_82290_ + 1.0E-7 < this.maxZ + blockZ && box.f_82293_ - 1.0E-7 > this.minZ + blockZ;
    }

    public void m_83286_(Shapes.DoubleLineConsumer boxConsumer) {
        boxConsumer.m_83161_(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

