/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.classloading;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModValidator;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.util.CommonModUtil;
import org.objectweb.asm.Type;

public class ATInjector {
    public static void injectModATs() {
        CommonModUtil.runWithoutCrash(() -> {
            ModValidator validator = (ModValidator)ObfuscationReflectionHelper.getPrivateValue(FMLLoader.class, null, (String)"modValidator");
            List modFiles = (List)ObfuscationReflectionHelper.getPrivateValue(ModValidator.class, (Object)validator, (String)"candidateMods");
            List list = modFiles.stream().filter(file -> file.getAccessTransformer().isPresent()).map(file -> Pair.of((Object)file, (Object)((Path)file.getAccessTransformer().get()))).collect(Collectors.toList());
            if (list.size() > 0) {
                ModernFixMixinPlugin.instance.logger.warn("Applying ATs from {} mods despite being in errored state, this might cause a crash!", (Object)list.size());
                for (Pair pair : list) {
                    try {
                        FMLLoader.addAccessTransformer((Path)((Path)pair.getRight()), (ModFile)((ModFile)pair.getLeft()));
                    }
                    catch (RuntimeException e) {
                        ModernFixMixinPlugin.instance.logger.error("Exception occured applying AT from {}", (Object)((ModFile)pair.getLeft()).getFileName(), (Object)e);
                    }
                }
            }
            try {
                Launcher launcher = Launcher.INSTANCE;
                Field launchPlugins = Launcher.class.getDeclaredField("launchPlugins");
                launchPlugins.setAccessible(true);
                LaunchPluginHandler handler = (LaunchPluginHandler)launchPlugins.get(launcher);
                Field plugins = LaunchPluginHandler.class.getDeclaredField("plugins");
                plugins.setAccessible(true);
                Map map = (Map)plugins.get(handler);
                HashMap<String, ILaunchPluginService> newMap = new HashMap<String, ILaunchPluginService>(map);
                NonTransformingLaunchPluginService.class.getName();
                newMap.replaceAll((name, plugin) -> {
                    if (plugin.getClass().getName().startsWith("org.spongepowered.asm.launch.MixinLaunchPlugin")) {
                        ModernFixMixinPlugin.instance.logger.warn("Disabling plugin '{}': {}", name, (Object)plugin.getClass().getName());
                        return new NonTransformingLaunchPluginService((ILaunchPluginService)plugin);
                    }
                    return plugin;
                });
                plugins.set(handler, newMap);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }, "applying mod ATs in errored state");
    }

    static class NonTransformingLaunchPluginService
    implements ILaunchPluginService {
        private final ILaunchPluginService delegate;
        private static final EnumSet<ILaunchPluginService.Phase> NEVER = EnumSet.noneOf(ILaunchPluginService.Phase.class);

        NonTransformingLaunchPluginService(ILaunchPluginService delegate) {
            this.delegate = delegate;
        }

        public String name() {
            return this.delegate.name();
        }

        public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
            return NEVER;
        }

        public void offerResource(Path resource, String name) {
            this.delegate.offerResource(resource, name);
        }

        public void addResources(List<SecureJar> resources) {
            this.delegate.addResources(resources);
        }

        public void initializeLaunch(ILaunchPluginService.ITransformerLoader transformerLoader, NamedPath[] specialPaths) {
            this.delegate.initializeLaunch(transformerLoader, specialPaths);
        }

        public <T> T getExtension() {
            return (T)this.delegate.getExtension();
        }

        public void customAuditConsumer(String className, Consumer<String[]> auditDataAcceptor) {
            this.delegate.customAuditConsumer(className, auditDataAcceptor);
        }
    }
}

