/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.world.level.block.Block;

public class RenderLayerRegistry {
    protected Map<Block, Layer> mapping = new HashMap<Block, Layer>();
    protected Map<Block, Block> inheritances = new HashMap<Block, Block>();

    public void put(Block block, Layer layer) {
        if (this.mapping == null) {
            throw new IllegalStateException("Already finalized RenderLayerRegistry");
        }
        this.mapping.put(block, layer);
    }

    public void mock(Block block, Block inheritFrom) {
        if (this.inheritances == null) {
            throw new IllegalStateException("Already finalized RenderLayerRegistry");
        }
        this.inheritances.put(block, inheritFrom);
    }

    public void finalize(BiConsumer<Block, Layer> action) {
        for (Block b : this.inheritances.keySet()) {
            Block inheritFrom = this.inheritances.get(b);
            Layer layer = this.mapping.get(inheritFrom);
            if (layer == null) continue;
            this.mapping.put(b, layer);
        }
        this.mapping.forEach(action);
        this.mapping = null;
        this.inheritances = null;
    }

    public static enum Layer {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

