/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.artisttable;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.gui.ArtistTableScreen;
import me.dantaeusb.zetter.client.gui.artisttable.AbstractArtistTableWidget;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PreviewWidget
extends AbstractArtistTableWidget
implements Renderable,
GuiEventListener {
    private static final Component EMPTY_TITLE = Component.m_237115_((String)"container.zetter.artist_table.combined_canvas.empty");
    private static final Component INVALID_TITLE = Component.m_237115_((String)"container.zetter.artist_table.combined_canvas.invalid");
    private static final Component LOADING_TITLE = Component.m_237115_((String)"container.zetter.artist_table.combined_canvas.loading");
    private static final int size = 64;

    public PreviewWidget(ArtistTableScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 64, 64, (Component)Component.m_237115_((String)"container.zetter.artist_table.combined_canvas"));
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 1.0f);
        DummyCanvasData canvasData = ((ArtistTableMenu)this.parentScreen.m_6262_()).getAction().getCanvasData();
        this.drawCanvas(guiGraphics, canvasData);
        poseStack.m_85849_();
    }

    private void drawCanvas(GuiGraphics guiGraphics, @Nullable DummyCanvasData canvasData) {
        if (canvasData != null) {
            PoseStack poseStack = guiGraphics.m_280168_();
            int scale = PreviewWidget.getScale(canvasData);
            Tuple<Integer, Integer> displacement = PreviewWidget.getDisplacement(canvasData, scale);
            poseStack.m_85836_();
            poseStack.m_252880_((float)((Integer)displacement.m_14418_()).intValue(), (float)((Integer)displacement.m_14419_()).intValue(), 1.0f);
            poseStack.m_85841_((float)scale, (float)scale, 1.0f);
            MultiBufferSource.BufferSource renderTypeBufferImpl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            CanvasRenderer.getInstance().renderCanvas(poseStack, (MultiBufferSource)renderTypeBufferImpl, "zetter_combined_canvas", canvasData, 0xF000F0);
            renderTypeBufferImpl.m_109911_();
            poseStack.m_85849_();
        }
    }

    public static Tuple<Integer, Integer> getDisplacement(@Nullable DummyCanvasData canvasData, int scale) {
        if (canvasData != null) {
            int xSize = canvasData.getWidth() / Helper.getResolution().getNumeric() * Helper.getBasicResolution().getNumeric() * scale;
            int ySize = canvasData.getHeight() / Helper.getResolution().getNumeric() * Helper.getBasicResolution().getNumeric() * scale;
            int width = Helper.getBasicResolution().getNumeric() * 4;
            int height = Helper.getBasicResolution().getNumeric() * 4;
            return new Tuple((Object)((width - xSize) / 2), (Object)((height - ySize) / 2));
        }
        return new Tuple((Object)0, (Object)0);
    }

    public static int getScale(@Nullable DummyCanvasData canvasData) {
        if (canvasData != null) {
            int xScale = 4 / (canvasData.getWidth() / Helper.getResolution().getNumeric());
            int yScale = 4 / (canvasData.getHeight() / Helper.getResolution().getNumeric());
            return Math.min(xScale, yScale);
        }
        return 1;
    }

    @Nullable
    public static CanvasData getCanvasData(Level world, String canvasName) {
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(world);
        return (CanvasData)((Object)canvasTracker.getCanvasData(canvasName));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        switch (((ArtistTableMenu)this.parentScreen.m_6262_()).getActionState()) {
            case EMPTY: {
                return EMPTY_TITLE;
            }
            case INVALID: {
                return INVALID_TITLE;
            }
            case NOT_LOADED: {
                return LOADING_TITLE;
            }
        }
        return this.m_6035_();
    }
}

