/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.core;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.ZetterConfig;
import me.dantaeusb.zetter.client.gui.PaintingScreen;
import me.dantaeusb.zetter.client.gui.overlay.CanvasOverlay;
import me.dantaeusb.zetter.core.ZetterOverlays;
import me.dantaeusb.zetter.event.CanvasOverlayViewEvent;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;

public class ClientHelper {
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});

    public static boolean openUriAllowed() {
        return (Boolean)Minecraft.m_91087_().f_91066_.m_231815_().m_231551_();
    }

    public static boolean helpButtonAllowed() {
        return ClientHelper.openUriAllowed() && (Boolean)ZetterConfig.CLIENT.enableHelpButton.get() != false;
    }

    public static void openUriPrompt(Screen parentScreen, String href) {
        Minecraft mc = Minecraft.m_91087_();
        if (!ClientHelper.openUriAllowed()) {
            return;
        }
        try {
            URI uri = new URI(href);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(href, "Missing protocol");
            }
            if (!ALLOWED_PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(href, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            if (((Boolean)mc.f_91066_.m_231816_().m_231551_()).booleanValue()) {
                mc.m_91152_((Screen)new ConfirmLinkScreen(result -> {
                    if (result) {
                        ClientHelper.openUri(uri);
                    }
                    mc.m_91152_(parentScreen);
                }, href, true));
            } else {
                ClientHelper.openUri(uri);
            }
        }
        catch (URISyntaxException e) {
            Zetter.LOG.error("Can't open url {}", (Object)href, (Object)e);
        }
    }

    public static void openCanvasScreen(Player player, String canvasCode, CanvasData canvasData, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)PaintingScreen.createScreenForCanvas(player, canvasCode, canvasData, hand));
    }

    public static void openPaintingScreen(Player player, String canvasCode, PaintingData canvasData, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)PaintingScreen.createScreenForPainting(player, canvasCode, canvasData, hand));
    }

    private static void openUri(URI uri) {
        Util.m_137581_().m_137648_(uri);
    }

    public static void showOverlay(AbstractCanvasData data) {
        for (CanvasOverlay<?> overlay : ZetterOverlays.OVERLAYS.values()) {
            overlay.hide();
        }
        CanvasOverlayViewEvent<AbstractCanvasData> viewEvent = new CanvasOverlayViewEvent<AbstractCanvasData>(data);
        MinecraftForge.EVENT_BUS.post(viewEvent);
    }
}

