/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network;

import java.io.IOException;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.event.CanvasViewEvent;
import me.dantaeusb.zetter.network.packet.SCanvasHistoryActionPacket;
import me.dantaeusb.zetter.network.packet.SCanvasRemovalPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncExportErrorPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncExportPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncViewPacket;
import me.dantaeusb.zetter.network.packet.SEaselCanvasInitializationPacket;
import me.dantaeusb.zetter.network.packet.SEaselResetPacket;
import me.dantaeusb.zetter.network.packet.SEaselStateSyncPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ClientHandler {
    public static void processCanvasSync(SCanvasSyncPacket<?> packetIn, Level world) {
        try {
            String canvasCode = packetIn.canvasCode;
            Object canvasData = packetIn.canvasData;
            long timestamp = packetIn.timestamp;
            CanvasTracker canvasTracker = (CanvasTracker)world.getCapability(ZetterCapabilities.CANVAS_TRACKER).orElseThrow(() -> new RuntimeException("Cannot find world canvas capability"));
            canvasTracker.registerCanvasData(canvasCode, (AbstractCanvasData)((Object)canvasData), timestamp);
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasSyncView(SCanvasSyncViewPacket packetIn, Level world) {
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            String canvasCode = packetIn.canvasCode;
            AbstractCanvasData canvasData = packetIn.canvasData;
            CanvasViewEvent event = new CanvasViewEvent((Player)player, canvasCode, canvasData, packetIn.getHand());
            MinecraftForge.EVENT_BUS.post((Event)event);
            ClientHandler.processCanvasSync(packetIn, world);
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasSyncExportError(SCanvasSyncExportPacket packetIn, Level world) {
        try {
            String canvasCode = packetIn.canvasCode;
            PaintingData paintingData = (PaintingData)packetIn.canvasData;
            Helper.exportPainting(Minecraft.m_91087_().f_91069_, canvasCode, paintingData);
            Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237110_((String)"console.zetter.result.exported_painting_client", (Object[])new Object[]{paintingData.getPaintingName()}), false);
        }
        catch (IOException e) {
            if (Minecraft.m_91087_().m_91403_() == null) {
                Zetter.LOG.error((Object)e);
                return;
            }
            Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237110_((String)"console.zetter.error.file_write_error", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED), false);
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasSyncExportError(SCanvasSyncExportErrorPacket packetIn, Level world) {
        if (Minecraft.m_91087_().m_91403_() == null) {
            Zetter.LOG.error(packetIn.errorCode);
            return;
        }
        Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237110_((String)packetIn.errorCode, (Object[])new Object[]{packetIn.errorMessage}).m_130940_(ChatFormatting.RED), false);
    }

    public static void processEaselStateSync(SEaselStateSyncPacket packetIn, Level world) {
        try {
            EaselEntity easel = (EaselEntity)world.m_6815_(packetIn.easelEntityId);
            if (easel != null) {
                easel.getStateHandler().processHistorySyncClient(packetIn.canvasCode, packetIn.sync, packetIn.snapshot, packetIn.unsyncedActions);
            } else {
                Zetter.LOG.warn("Unable to find entity " + packetIn.easelEntityId + " disregarding canvas snapshot");
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasHistory(SCanvasHistoryActionPacket packetIn, Level world) {
        try {
            EaselEntity easel = (EaselEntity)world.m_6815_(packetIn.easelEntityId);
            if (easel != null) {
                if (packetIn.canceled) {
                    easel.getStateHandler().undo(packetIn.actionId);
                } else {
                    easel.getStateHandler().redo(packetIn.actionId);
                }
            } else {
                Zetter.LOG.warn("Unable to find entity " + packetIn.easelEntityId + " disregarding canvas changes");
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasRemoval(SCanvasRemovalPacket packetIn, Level world) {
        try {
            String canvasCode = packetIn.canvasCode();
            long timestamp = packetIn.timestamp();
            CanvasTracker canvasTracker = (CanvasTracker)world.getCapability(ZetterCapabilities.CANVAS_TRACKER).orElseThrow(() -> new RuntimeException("Cannot find world canvas capability"));
            canvasTracker.unregisterCanvasData(canvasCode);
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processEaselCanvasInitialization(SEaselCanvasInitializationPacket packetIn, Level world) {
        try {
            EaselEntity easel = (EaselEntity)world.m_6815_(packetIn.easelEntityId);
            ClientHandler.processCanvasSync(packetIn, world);
            if (easel != null) {
                easel.getStateHandler().reset();
                easel.getEaselContainer().handleCanvasChange(packetIn.canvasCode);
            } else {
                Zetter.LOG.warn("Unable to find entity " + packetIn.easelEntityId + " disregarding history reset");
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processEaselReset(SEaselResetPacket packetIn, Level world) {
        try {
            EaselEntity easel = (EaselEntity)world.m_6815_(packetIn.easelEntityId);
            if (easel != null) {
                easel.getStateHandler().reset();
            } else {
                Zetter.LOG.warn("Unable to find entity " + packetIn.easelEntityId + " disregarding history reset");
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }
}

