/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.security.InvalidParameterException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CCanvasRequestExportPacket {
    @Nullable
    public final String requestCode;
    @Nullable
    public final String requestTitle;

    public CCanvasRequestExportPacket(@Nullable String requestCode, @Nullable String requestTitle) {
        if (requestCode == null && requestTitle == null) {
            throw new InvalidParameterException("One of the parameters should be non-null: code or title");
        }
        this.requestCode = requestCode;
        this.requestTitle = requestTitle;
    }

    public static CCanvasRequestExportPacket readPacketData(FriendlyByteBuf buf) {
        try {
            String requestCode = null;
            if (buf.readBoolean()) {
                requestCode = buf.m_130136_(Short.MAX_VALUE);
            }
            String requestTitle = null;
            if (buf.readBoolean()) {
                requestTitle = buf.m_130136_(Short.MAX_VALUE);
            }
            return new CCanvasRequestExportPacket(requestCode, requestTitle);
        }
        catch (Exception e) {
            Zetter.LOG.warn("Exception while reading CCanvasRequestExportPacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf buf) {
        if (this.requestCode != null) {
            buf.writeBoolean(true);
            buf.m_130072_(this.requestCode, Short.MAX_VALUE);
        } else {
            buf.writeBoolean(false);
        }
        if (this.requestTitle != null) {
            buf.writeBoolean(true);
            buf.m_130072_(this.requestTitle, Short.MAX_VALUE);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static void handle(CCanvasRequestExportPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CCanvasRequestExportPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processCanvasExportRequest(packetIn, sendingPlayer));
    }

    public String toString() {
        return "CCanvasRequestExportPacket[requestCode=" + this.requestCode + ",requestTitle=" + this.requestTitle + "]";
    }
}

