/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.parameters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.dantaeusb.zetter.painting.Tools;
import me.dantaeusb.zetter.painting.parameters.BrushParameters;
import me.dantaeusb.zetter.painting.parameters.BucketParameters;
import me.dantaeusb.zetter.painting.parameters.CloneableParameter;
import me.dantaeusb.zetter.painting.parameters.PencilParameters;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.SerializationException;

public abstract class AbstractToolParameters
implements Cloneable {
    protected HashMap<String, Object> values = new HashMap();

    public AbstractToolParameters clone() throws CloneNotSupportedException {
        AbstractToolParameters copy = (AbstractToolParameters)super.clone();
        copy.values = new HashMap();
        for (Map.Entry<String, Object> valueEntry : this.values.entrySet()) {
            if (valueEntry.getValue() instanceof Number || valueEntry.getValue() instanceof String || valueEntry.getValue() instanceof Boolean) {
                copy.values.put(valueEntry.getKey(), valueEntry.getValue());
                continue;
            }
            if (valueEntry.getValue() instanceof CloneableParameter) {
                copy.values.put(valueEntry.getKey(), ((CloneableParameter)valueEntry.getValue()).clone());
                continue;
            }
            throw new CloneNotSupportedException("Value of parameter " + valueEntry.getKey() + " is not cloneable!");
        }
        return copy;
    }

    public static void writePacketData(AbstractToolParameters toolParameters, FriendlyByteBuf buffer) {
        buffer.m_236828_(toolParameters.values.entrySet(), AbstractToolParameters::writeEntry);
    }

    private static void writeEntry(FriendlyByteBuf buffer, Map.Entry<String, Object> entry) {
        try {
            buffer.m_130072_(entry.getKey(), 128);
            ByteArrayOutputStream streamOutput = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(streamOutput);
            stream.writeObject(entry.getValue());
            streamOutput.close();
            byte[] output = streamOutput.toByteArray();
            buffer.writeInt(output.length);
            buffer.writeBytes(streamOutput.toByteArray());
        }
        catch (IOException e) {
            throw new SerializationException("Unable to write value for parameter " + entry.getKey());
        }
    }

    public static AbstractToolParameters readPacketData(FriendlyByteBuf buffer, Tools tool) {
        AbstractToolParameters toolParameters = switch (tool) {
            case Tools.BRUSH -> new BrushParameters();
            case Tools.BUCKET -> new BucketParameters();
            default -> new PencilParameters();
        };
        List rawParameters = (List)buffer.m_236838_(NonNullList::m_182647_, AbstractToolParameters::readEntry);
        toolParameters.values = (HashMap)rawParameters.stream().collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_));
        return toolParameters;
    }

    private static Tuple<String, Object> readEntry(FriendlyByteBuf buffer) {
        String key = buffer.m_130136_(128);
        int length = buffer.readInt();
        byte[] input = new byte[length];
        buffer.readBytes(length).nioBuffer().get(input);
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(input);
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            Object value = objectStream.readObject();
            return new Tuple((Object)key, value);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to read value for parameter " + key);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Incorrect or forbidden type for parameter " + key);
        }
    }
}

