/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.parameters;

import java.security.InvalidParameterException;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.parameters.BlendingParameterHolder;
import me.dantaeusb.zetter.painting.parameters.DitheringParameterHolder;
import me.dantaeusb.zetter.painting.parameters.IntensityParameterHolder;
import me.dantaeusb.zetter.painting.parameters.SizeParameterHolder;
import me.dantaeusb.zetter.painting.pipes.BlendingPipe;
import me.dantaeusb.zetter.painting.pipes.DitheringPipe;

public class PencilParameters
extends AbstractToolParameters
implements SizeParameterHolder,
IntensityParameterHolder,
BlendingParameterHolder,
DitheringParameterHolder {
    public static final float MIN_SIZE = 1.0f;
    public static final float MAX_SIZE = 6.0f;

    public PencilParameters() {
        this(1.0f, 1.0f, BlendingPipe.BlendingOption.DEFAULT, DitheringPipe.DitheringOption.DEFAULT);
    }

    public PencilParameters(float size, float intensity, BlendingPipe.BlendingOption blending, DitheringPipe.DitheringOption dithering) {
        this.values.put("Size", Float.valueOf(size));
        this.values.put("Intensity", Float.valueOf(intensity));
        this.values.put("Blending", blending.name());
        this.values.put("Dithering", dithering.name());
    }

    @Override
    public float getSize() {
        return ((Float)this.values.get("Size")).floatValue();
    }

    @Override
    public void setSize(float size) {
        if (size < 1.0f || size > 6.0f) {
            throw new InvalidParameterException("Incorrect size");
        }
        this.values.put("Size", Float.valueOf(size));
    }

    @Override
    public float getIntensity() {
        return ((Float)this.values.get("Intensity")).floatValue();
    }

    @Override
    public void setIntensity(float intensity) {
        if (intensity < 0.0f || intensity > 1.0f) {
            throw new InvalidParameterException("Intensity out of bounds");
        }
        this.values.put("Intensity", Float.valueOf(intensity));
    }

    @Override
    public BlendingPipe.BlendingOption getBlending() {
        return BlendingPipe.BlendingOption.valueOf((String)this.values.get("Blending"));
    }

    @Override
    public void setBlending(BlendingPipe.BlendingOption blending) {
        this.values.put("Blending", blending.name());
    }

    @Override
    public DitheringPipe.DitheringOption getDithering() {
        return DitheringPipe.DitheringOption.valueOf((String)this.values.get("Dithering"));
    }

    @Override
    public void setDithering(DitheringPipe.DitheringOption dithering) {
        this.values.put("Dithering", dithering.name());
    }
}

