/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.painting.parameters.PencilParameters;
import me.dantaeusb.zetter.painting.pipes.BlendingPipe;
import me.dantaeusb.zetter.painting.pipes.DitheringPipe;
import me.dantaeusb.zetter.painting.pipes.Pipe;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.chat.Component;

public class Pencil
extends AbstractTool<PencilParameters> {
    public static final int HOTKEY = 80;
    private final Component translatableComponent = Component.m_237115_((String)"container.zetter.painting.tools.pencil");
    private HashMap<Integer, AbstractTool.ToolShape> shapes = new HashMap<Integer, AbstractTool.ToolShape>(){
        {
            this.put(1, new AbstractTool.ToolShape());
            this.put(2, new AbstractTool.ToolShape(new int[][]{{1, 1}, {1, 1}}));
            this.put(3, new AbstractTool.ToolShape(new int[][]{{0, 1, 0}, {1, 1, 1}, {0, 1, 0}}));
            this.put(4, new AbstractTool.ToolShape(new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}));
            this.put(5, new AbstractTool.ToolShape(new int[][]{{0, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {1, 1, 1, 1, 1}, {0, 1, 1, 1, 0}, {0, 0, 1, 0, 0}}));
            this.put(6, new AbstractTool.ToolShape(new int[][]{{0, 1, 1, 1, 0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 1, 1, 1, 0}}));
        }
    };

    public Pencil() {
        super((List<Pipe>)new ArrayList<Pipe>(){
            {
                this.add(new DitheringPipe());
                this.add(new BlendingPipe());
            }
        });
    }

    @Override
    public AbstractTool.ToolShape getShape(PencilParameters params) {
        return this.shapes.get(Math.round(params.getSize()));
    }

    @Override
    public Component getTranslatableComponent() {
        return this.translatableComponent;
    }

    @Override
    public boolean shouldAddAction(CanvasData canvasData, PencilParameters params, float newPosX, float newPosY, @Nullable Float lastPosX, @Nullable Float lastPosY) {
        AbstractTool.ToolShape shape = this.getShape(params);
        int distance = (int)Math.ceil((double)shape.getSize() / 2.0);
        if (newPosX < (float)(-distance) || newPosX > (float)(canvasData.getWidth() + distance)) {
            return false;
        }
        if (newPosY < (float)(-distance) || newPosY > (float)(canvasData.getHeight() + distance)) {
            return false;
        }
        if (lastPosX == null || lastPosY == null) {
            return true;
        }
        return Math.floor(lastPosX.floatValue()) != Math.floor(newPosX) || Math.floor(lastPosY.floatValue()) != Math.floor(newPosY);
    }

    @Override
    public int useTool(CanvasData canvas, PencilParameters params, int color, float posX, float posY) {
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        int canvasSize = canvas.getWidth() * canvas.getHeight();
        AbstractTool.ToolShape shape = this.getShape(params);
        if (shape != null) {
            int offset = -(shape.getSize() / 2);
            int count = 0;
            for (int y = 0; y < shape.matrix.length; ++y) {
                for (int x = 0; x < shape.matrix[y].length; ++x) {
                    if (shape.matrix[y][x] == 0) continue;
                    int canvasX = (int)Math.floor(posX) + offset + x;
                    int canvasY = (int)Math.floor(posY) + offset + y;
                    if (canvasX < 0 || canvasX >= width || canvasY < 0 || canvasY >= height) continue;
                    int index = canvasY * width + canvasX;
                    this.pixelChange(canvas, params, color, index, 1.0f);
                    ++count;
                }
            }
            return count;
        }
        int index = (int)(Math.floor(posY) * (double)width + Math.floor(posX));
        this.pixelChange(canvas, params, color, index, 1.0f);
        return 1;
    }
}

