/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.server.command.PaintingInput;
import me.dantaeusb.zetter.server.command.PaintingLookupArgument;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RestoreCommand {
    private static final DynamicCommandExceptionType ERROR_PAINTING_NOT_FOUND = new DynamicCommandExceptionType(code -> Component.m_237110_((String)"console.zetter.error.painting_not_found", (Object[])new Object[]{code}));

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"restore").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"painting", (ArgumentType)PaintingLookupArgument.painting()).executes(ctx -> RestoreCommand.execute((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_230896_(), (Level)((CommandSourceStack)ctx.getSource()).m_81372_(), PaintingLookupArgument.getPaintingInput(ctx, "painting"))));
    }

    private static int execute(CommandSourceStack source, Player player, Level level, PaintingInput paintingInput) throws CommandRuntimeException, CommandSyntaxException {
        ItemStack paintingItem = new ItemStack((ItemLike)ZetterItems.PAINTING.get());
        if (!paintingInput.hasPaintingData(level)) {
            throw ERROR_PAINTING_NOT_FOUND.create((Object)paintingInput.getPaintingCode());
        }
        String paintingCode = paintingInput.getPaintingCode();
        PaintingData paintingData = paintingInput.getPaintingData();
        PaintingItem.storePaintingData(paintingItem, paintingCode, paintingData, 1);
        boolean flag = player.m_150109_().m_36054_(paintingItem);
        if (flag && paintingItem.m_41619_()) {
            paintingItem.m_41764_(1);
            ItemEntity itemEntity = player.m_36176_(paintingItem, false);
            if (itemEntity != null) {
                itemEntity.m_32065_();
            }
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            player.f_36096_.m_38946_();
        } else {
            ItemEntity itemEntity = player.m_36176_(paintingItem, false);
            if (itemEntity != null) {
                itemEntity.m_32061_();
                itemEntity.m_266426_(player.m_20148_());
            }
        }
        source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, paintingItem.m_41611_(), player.m_5446_()}), true);
        return 1;
    }
}

