/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons;

import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.util.StorageUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.items.ItemMekaBow;
import meranha.mekaweapons.items.ItemMekaTana;
import meranha.mekaweapons.items.modules.DrawSpeedUnit;
import meranha.mekaweapons.items.modules.WeaponAttackAmplificationUnit;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekaWeaponsUtils {
    public static long getBaseEnergyUsage(@NotNull ItemStack stack) {
        Item weapon = stack.m_41720_();
        CachedFloatingLongValue energy = null;
        if (weapon instanceof ItemMekaBow) {
            energy = MekaWeapons.general.mekaBowEnergyUsage;
        } else if (weapon instanceof ItemMekaTana) {
            energy = MekaWeapons.general.mekaTanaEnergyUsage;
        }
        return energy != null ? ((FloatingLong)energy.get()).longValue() : 0L;
    }

    public static long getEnergyNeeded(@Nullable ItemStack weaponStack) {
        if (weaponStack == null) {
            return -1L;
        }
        long energy = MekaWeaponsUtils.getBaseEnergyUsage(weaponStack);
        if (weaponStack.m_41720_() instanceof ItemMekaBow) {
            IModule<DrawSpeedUnit> drawSpeedUnit;
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.ARROWENERGY_UNIT)) {
                energy += ((FloatingLong)MekaWeapons.general.mekaBowEnergyArrowUsage.get()).longValue();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.AUTOFIRE_UNIT)) {
                energy += ((FloatingLong)MekaWeapons.general.mekabowAutoFireEnergyUsage.get()).longValue();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.GRAVITYDAMPENER_UNIT)) {
                energy += ((FloatingLong)MekaWeapons.general.mekabowGravityDampenerUsage.get()).longValue();
            }
            if ((drawSpeedUnit = MekaWeaponsUtils.getEnabledModule(weaponStack, WeaponsModules.DRAWSPEED_UNIT)) != null) {
                energy += (long)drawSpeedUnit.getInstalledCount() * ((FloatingLong)MekaWeapons.general.mekabowDrawSpeedUsage.get()).longValue();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.LOOTING_UNIT)) {
                energy += ((FloatingLong)MekaWeapons.general.mekaBowLootingEnergyUsage.get()).longValue();
            }
        } else if (weaponStack.m_41720_() instanceof ItemMekaTana) {
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.SWEEPING_UNIT)) {
                energy += ((FloatingLong)MekaWeapons.general.mekaTanaSweepingEnergyUsage.get()).longValue();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.LOOTING_UNIT)) {
                energy += ((FloatingLong)MekaWeapons.general.mekaTanaLootingEnergyUsage.get()).longValue();
            }
        }
        IModule<WeaponAttackAmplificationUnit> attackAmplificationUnit = MekaWeaponsUtils.getEnabledModule(weaponStack, WeaponsModules.ATTACKAMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null) {
            energy *= (long)((WeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit();
        }
        return energy;
    }

    public static int getBarCustomColor(@NotNull ItemStack stack) {
        if (MekaWeaponsUtils.isEnergyInsufficient(stack)) {
            return MekanismConfig.client.hudDangerColor.get();
        }
        return MekanismConfig.client.energyColor.get();
    }

    public static int getBaseDamage(@NotNull ItemStack stack) {
        Item weapon = stack.m_41720_();
        CachedIntValue damage = null;
        if (weapon instanceof ItemMekaBow) {
            damage = MekaWeapons.general.mekaBowBaseDamage;
        } else if (weapon instanceof ItemMekaTana) {
            damage = MekaWeapons.general.mekaTanaBaseDamage;
        }
        return damage != null ? damage.get() : 0;
    }

    public static long getTotalDamage(@NotNull ItemStack weapon) {
        if (MekaWeaponsUtils.isEnergyInsufficient(weapon)) {
            return 20L;
        }
        long damage = MekaWeaponsUtils.getBaseDamage(weapon);
        IModule<WeaponAttackAmplificationUnit> attackAmplificationUnit = MekaWeaponsUtils.getEnabledModule(weapon, WeaponsModules.ATTACKAMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null) {
            damage *= (long)((WeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit();
        }
        return damage;
    }

    public static boolean isEnergyInsufficient(@Nullable IEnergyContainer energyContainer, long energyNeeded) {
        return energyContainer == null || energyContainer.getEnergy().longValue() < energyNeeded;
    }

    public static boolean isEnergyInsufficient(@NotNull ItemStack weapon) {
        return MekaWeaponsUtils.isEnergyInsufficient(StorageUtils.getEnergyContainer((ItemStack)weapon, (int)0), MekaWeaponsUtils.getEnergyNeeded(weapon));
    }

    @Nullable
    public static <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getEnabledModule(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        return IModuleHelper.INSTANCE.load(stack, typeProvider);
    }

    public static boolean isModuleEnabled(ItemStack stack, IModuleDataProvider<?> type) {
        return IModuleHelper.INSTANCE.isEnabled(stack, type);
    }
}

