/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MekaArrowEntity
extends AbstractArrow {
    private IntOpenHashSet piercingIgnoreEntityIds;
    private List<Entity> piercedAndKilledEntities;

    public MekaArrowEntity(EntityType<? extends MekaArrowEntity> entityType, Level level, ItemStack itemStack) {
        super(entityType, level);
    }

    public MekaArrowEntity(Level level, double x, double y, double z, ItemStack projectileStack, ItemStack weaponStack) {
        super((EntityType)MekaWeapons.MEKA_ARROW.get(), x, y, z, level);
        this.setPickup(!MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.ARROWENERGY_UNIT));
        this.m_20242_(MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.GRAVITYDAMPENER_UNIT));
        this.m_36781_(MekaWeaponsUtils.getTotalDamage(weaponStack));
    }

    public MekaArrowEntity(EntityType<MekaArrowEntity> entityType, Level level) {
        this(entityType, level, new ItemStack((ItemLike)Items.f_42412_));
    }

    public MekaArrowEntity(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        super((EntityType)MekaWeapons.MEKA_ARROW.get(), arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), arrow.m_9236_());
        this.setPickup(!MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.ARROWENERGY_UNIT));
        this.m_20242_(MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.GRAVITYDAMPENER_UNIT));
        this.m_36781_(MekaWeaponsUtils.getTotalDamage(weaponStack));
        this.m_5602_(arrow.m_19749_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 100 && !this.f_36703_) {
            this.m_20242_(false);
        }
    }

    public void m_5790_(@NotNull EntityHitResult pResult) {
        DamageSource damagesource;
        Entity entity1;
        Entity entity = pResult.m_82443_();
        double i = this.m_36789_();
        if (this.m_36796_() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.m_19879_());
        }
        if ((entity1 = this.m_19749_()) == null) {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity);
            }
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.m_9236_().f_46443_ && this.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.m_150123_() > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6 * d0);
                    if (vec3.m_82556_() > 0.0) {
                        livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
                if (livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingentity);
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity1;
                    if (this.piercedAndKilledEntities != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, this.piercedAndKilledEntities);
                    } else if (!entity.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, List.of(entity));
                    }
                }
            }
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_146870_();
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    public void setPickup(boolean pickup) {
        this.f_36705_ = pickup ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }
}

