/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.ButtonWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.packets.PortalActivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalDeactivatePacket;
import com.supermartijn642.wormhole.portal.screen.PortalGroupScreen;
import com.supermartijn642.wormhole.portal.screen.PortalRendererHelper;
import com.supermartijn642.wormhole.portal.screen.ScreenBlockRenderer;
import com.supermartijn642.wormhole.screen.EnergyBarWidget;
import com.supermartijn642.wormhole.screen.WormholeColoredButton;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PortalOverviewScreen
extends PortalGroupScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("wormhole", "textures/gui/portal_overview_screen.png");
    private static final ResourceLocation LOCATION_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/location_icon.png");
    private static final ResourceLocation ENERGY_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/lightning_icon.png");
    private static final ResourceLocation TELEPORT_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/teleport_icon.png");
    private static final ResourceLocation STAR_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/star_icon.png");
    private static final ResourceLocation DIMENSION_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/dimension_icon.png");
    private static final ResourceLocation CHECKMARK_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/checkmark_icon.png");
    private static final ResourceLocation CROSS_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/cross_icon.png");
    private static final ResourceLocation WARNING_ICON = new ResourceLocation("wormhole", "textures/gui/select_target_screen/warning_icon.png");
    private static final ResourceLocation SEPARATOR = new ResourceLocation("wormhole", "textures/gui/select_target_screen/separator.png");
    private static final int WIDTH = 280;
    private static final int HEIGHT = 185;
    private WormholeColoredButton activateButton;

    public PortalOverviewScreen(BlockPos pos) {
        super(280, 185, pos);
    }

    protected Component getNarrationMessage(PortalGroup object) {
        return TextComponents.translation((String)"wormhole.portal.gui.title").get();
    }

    protected void addWidgets(PortalGroup group) {
        this.activateButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(45, 159, 60, 15, (Component)TextComponents.empty().get(), () -> Wormhole.CHANNEL.sendToServer((BasePacket)(((PortalGroup)this.object).isActive() ? new PortalDeactivatePacket((PortalGroup)this.object) : new PortalActivatePacket((PortalGroup)this.object)))));
        Supplier<Integer> energy = () -> ((PortalGroup)this.object).getStoredEnergy();
        Supplier<Integer> capacity = () -> ((PortalGroup)this.object).getEnergyCapacity();
        this.addWidget((Widget)new EnergyBarWidget(244, 55, 30, 82, energy, capacity));
        this.addWidget((Widget)new ButtonWidget(151, 159, 82, 13, (Component)TextComponents.translation((String)"wormhole.portal.gui.change_target").get(), () -> WormholeClient.openPortalTargetScreen(this.pos)));
    }

    protected void update(PortalGroup group) {
        super.update((Object)((PortalGroup)this.object));
        this.activateButton.setText((Component)TextComponents.translation((String)(group.isActive() ? "wormhole.portal.gui.deactivate" : "wormhole.portal.gui.activate")).get());
        if (group.isActive()) {
            this.activateButton.setColorRed();
        } else {
            this.activateButton.setColorGreen();
        }
    }

    protected void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, PortalGroup object) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        super.renderBackground(context, mouseX, mouseY, (Object)object);
    }

    protected void render(WidgetRenderContext context, int mouseX, int mouseY, PortalGroup group) {
        super.render(context, mouseX, mouseY, (Object)group);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.portal.gui.title").get(), (float)72.5f, (float)3.0f, (int)Integer.MAX_VALUE);
        PortalTarget target = group.getActiveTarget();
        this.renderInfo(context.poseStack(), group.getStoredEnergy(), group.getIdleEnergyCost(), group.getTeleportEnergyCost(), target);
    }

    private void renderInfo(PoseStack poseStack, int storedEnergy, int idleCost, int teleportCost, PortalTarget target) {
        PortalStatus status = target == null ? PortalStatus.NO_TARGET : (storedEnergy == 0 ? PortalStatus.NO_ENERGY : (storedEnergy < idleCost ? PortalStatus.NOT_ENOUGH_ENERGY : PortalStatus.OK));
        ScreenUtils.drawCenteredString((PoseStack)poseStack, (Component)TextComponents.translation((String)"wormhole.portal.gui.information").get(), (float)192.0f, (float)31.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)154.0f, (float)41.0f, (float)77.0f, (float)1.0f);
        ScreenUtils.bindTexture((ResourceLocation)status.getIcon());
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)151.0f, (float)47.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (Component)status.getStatus(), (float)162.0f, (float)48.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)ENERGY_ICON);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)151.0f, (float)59.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (String)EnergyFormat.formatEnergyPerTick((int)idleCost), (float)162.0f, (float)60.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)TELEPORT_ICON);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)150.0f, (float)70.0f, (float)11.0f, (float)11.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (String)(target == null ? "--" : EnergyFormat.formatEnergyWithUnit((int)teleportCost)), (float)162.0f, (float)72.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)154.0f, (float)85.0f, (float)77.0f, (float)1.0f);
        ScreenUtils.bindTexture((ResourceLocation)STAR_ICON);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)151.0f, (float)91.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((PoseStack)poseStack, (String)(target == null ? "--" : target.name), (float)162.0f, (float)92.0f, (int)Integer.MAX_VALUE);
        if (target != null) {
            ScreenUtils.bindTexture((ResourceLocation)LOCATION_ICON);
            ScreenUtils.drawTexture((PoseStack)poseStack, (float)151.0f, (float)103.0f, (float)9.0f, (float)9.0f);
            ScreenUtils.drawString((PoseStack)poseStack, (String)("(" + target.x + ", " + target.y + ", " + target.z + ")"), (float)162.0f, (float)104.0f, (int)Integer.MAX_VALUE);
            Block block = null;
            if (target.dimension.equals((Object)Level.f_46428_)) {
                block = Blocks.f_152481_;
            } else if (target.dimension.equals((Object)Level.f_46429_)) {
                block = Blocks.f_50134_;
            } else if (target.dimension.equals((Object)Level.f_46430_)) {
                block = Blocks.f_50259_;
            }
            if (block == null) {
                ScreenUtils.bindTexture((ResourceLocation)DIMENSION_ICON);
                ScreenUtils.drawTexture((PoseStack)poseStack, (float)151.0f, (float)115.0f, (float)9.0f, (float)9.0f);
            } else {
                ScreenBlockRenderer.drawBlock(poseStack, block, 155.5, 119.5, 5.5, 45.0f, 40.0f);
            }
            ScreenUtils.drawString((PoseStack)poseStack, (Component)target.getDimensionDisplayName(), (float)162.0f, (float)116.0f, (int)Integer.MAX_VALUE);
        }
    }

    protected void renderForeground(WidgetRenderContext context, int mouseX, int mouseY, PortalGroup group) {
        super.renderForeground(context, mouseX, mouseY, (Object)group);
        PortalRendererHelper.drawPortal(context.poseStack(), group.shape, this.x + 8, this.y + 19, 132.0f, 132.0f);
    }

    protected void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY, PortalGroup group) {
        if (mouseX >= 150 && mouseX <= 161 && mouseY >= 46 && mouseY <= 57) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.portal.gui.status").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 58 && mouseY <= 69) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.portal.gui.idle_cost").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 70 && mouseY <= 81) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.portal.gui.teleport_cost").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 90 && mouseY <= 101) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.portal.gui.target").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 102 && mouseY <= 113) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.portal.gui.target_location").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 114 && mouseY <= 125) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"wormhole.portal.gui.target_dimension").get(), (int)mouseX, (int)mouseY);
        }
        super.renderTooltips(context, mouseX, mouseY, (Object)group);
    }

    private static enum PortalStatus {
        OK("ok", ChatFormatting.GREEN, CHECKMARK_ICON),
        NOT_ENOUGH_ENERGY("not_enough_energy", ChatFormatting.RED, CROSS_ICON),
        NO_ENERGY("no_energy", ChatFormatting.RED, CROSS_ICON),
        NO_TARGET("no_target", ChatFormatting.GOLD, WARNING_ICON),
        NO_DIMENSIONAL_CORE("no_dimensional_core", ChatFormatting.RED, CROSS_ICON);

        private final String status;
        private final ChatFormatting color;
        private final ResourceLocation icon;

        private PortalStatus(String status, ChatFormatting color, ResourceLocation icon) {
            this.status = status;
            this.color = color;
            this.icon = icon;
        }

        public Component getStatus() {
            return TextComponents.translation((String)("wormhole.portal.gui.status." + this.status)).color(this.color).get();
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }
    }
}

