/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui.sync;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GenericContainerData<T> {
    private final GenericDataSerializers.DataSerializer<T> serializer;
    private final Supplier<T> get;
    private final Consumer<T> set;
    private T current;

    public GenericContainerData(GenericDataSerializers.DataSerializer<T> serializer, Supplier<T> get, Consumer<T> set) {
        this.serializer = serializer;
        this.get = get;
        this.set = set;
    }

    public GenericContainerData(GenericDataSerializers.DataSerializer<T> serializer, GetterAndSetter<T> io) {
        this.serializer = serializer;
        this.get = io.getter();
        this.set = io.setter();
    }

    public static GenericContainerData<Integer> int32(Supplier<Integer> get, Consumer<Integer> set) {
        return new GenericContainerData<Integer>(GenericDataSerializers.INT32, get, set);
    }

    public static GenericContainerData<?> energy(IMutableEnergyStorage storage) {
        return GenericContainerData.int32(() -> ((IMutableEnergyStorage)storage).getEnergyStored(), storage::setStoredEnergy);
    }

    public static GenericContainerData<FluidStack> fluid(FluidTank tank) {
        return new GenericContainerData<FluidStack>(GenericDataSerializers.FLUID_STACK, () -> ((FluidTank)tank).getFluid(), arg_0 -> ((FluidTank)tank).setFluid(arg_0));
    }

    public static GenericContainerData<Boolean> bool(Supplier<Boolean> get, Consumer<Boolean> set) {
        return new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, get, set);
    }

    public static GenericContainerData<Float> float32(Supplier<Float> get, Consumer<Float> set) {
        return new GenericContainerData<Float>(GenericDataSerializers.FLOAT, get, set);
    }

    public boolean needsUpdate() {
        T newValue = this.get.get();
        if (newValue == null && this.current == null) {
            return false;
        }
        if (this.current != null && newValue != null && this.serializer.equals().test(this.current, newValue)) {
            return false;
        }
        this.current = this.serializer.copy().apply(newValue);
        return true;
    }

    public void processSync(Object receivedData) {
        this.current = receivedData;
        this.set.accept(this.serializer.copy().apply(this.current));
    }

    public GenericDataSerializers.DataPair<T> dataPair() {
        return new GenericDataSerializers.DataPair<T>(this.serializer, this.current);
    }
}

