/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.ILinkedEntity;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.message.MessageLinkEntities;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class EntityBlockSwapper
extends Entity {
    private static final EntityDataAccessor<BlockState> ORIG_BLOCK_STATE = SynchedEntityData.m_135353_(EntityBlockSwapper.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Integer> RESTORE_TIME = SynchedEntityData.m_135353_(EntityBlockSwapper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> POS = SynchedEntityData.m_135353_(EntityBlockSwapper.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    protected int duration;
    protected boolean breakParticlesEnd;
    private BlockPos pos;

    public EntityBlockSwapper(EntityType<? extends EntityBlockSwapper> type, Level world) {
        super(type, world);
        this.breakParticlesEnd = false;
    }

    public EntityBlockSwapper(EntityType<? extends EntityBlockSwapper> type, Level world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        super(type, world);
        this.setStorePos(pos);
        this.setRestoreTime(duration);
        this.breakParticlesEnd = breakParticlesEnd;
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        if (!world.f_46443_) {
            this.setOrigBlock(world.m_8055_(pos));
            if (breakParticlesStart) {
                world.m_46961_(pos, false);
            }
            world.m_7731_(pos, newBlock, 19);
        }
        List swappers = world.m_45976_(EntityBlockSwapper.class, this.m_20191_());
        for (EntityBlockSwapper swapper : swappers) {
            if (swapper == this) continue;
            if (swapper instanceof EntityBlockSwapperSculptor) {
                EntityBlockSwapperSculptor swapperSculptor = (EntityBlockSwapperSculptor)swapper;
                this.setOrigBlock(swapperSculptor.getOrigBlockAtLocation(pos));
                continue;
            }
            this.setOrigBlock(swapper.getOrigBlock());
            swapper.m_146870_();
        }
    }

    public static void swapBlock(Level world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        if (!world.f_46443_) {
            EntityBlockSwapper swapper = new EntityBlockSwapper((EntityType<? extends EntityBlockSwapper>)((EntityType)EntityHandler.BLOCK_SWAPPER.get()), world, pos, newBlock, duration, breakParticlesStart, breakParticlesEnd);
            world.m_7967_((Entity)swapper);
        }
    }

    public boolean isBlockPosInsideSwapper(BlockPos pos) {
        return pos.equals((Object)this.getStorePos());
    }

    public boolean m_6000_(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return false;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ORIG_BLOCK_STATE, (Object)Blocks.f_50493_.m_49966_());
        this.m_20088_().m_135372_(RESTORE_TIME, (Object)20);
        this.m_20088_().m_135372_(POS, (Object)new BlockPos(0, 0, 0));
    }

    public int getRestoreTime() {
        return (Integer)this.f_19804_.m_135370_(RESTORE_TIME);
    }

    public void setRestoreTime(int restoreTime) {
        this.f_19804_.m_135381_(RESTORE_TIME, (Object)restoreTime);
        this.duration = restoreTime;
    }

    public BlockPos getStorePos() {
        return (BlockPos)this.f_19804_.m_135370_(POS);
    }

    public void setStorePos(BlockPos bpos) {
        this.f_19804_.m_135381_(POS, (Object)bpos);
        this.pos = bpos;
    }

    @Nullable
    public BlockState getOrigBlock() {
        return (BlockState)this.m_20088_().m_135370_(ORIG_BLOCK_STATE);
    }

    public void setOrigBlock(BlockState block) {
        this.m_20088_().m_135381_(ORIG_BLOCK_STATE, (Object)block);
    }

    public void restoreBlock() {
        List swappers = this.m_9236_().m_45976_(EntityBlockSwapper.class, this.m_20191_());
        if (!this.m_9236_().f_46443_) {
            boolean canReplace = true;
            for (EntityBlockSwapper swapper : swappers) {
                if (swapper == this || !swapper.isBlockPosInsideSwapper(this.pos)) continue;
                canReplace = false;
                break;
            }
            if (canReplace) {
                if (this.breakParticlesEnd) {
                    this.m_9236_().m_46961_(this.pos, false);
                }
                this.m_9236_().m_7731_(this.pos, this.getOrigBlock(), 19);
            }
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.canRestoreBlock()) {
            this.restoreBlock();
        }
    }

    protected boolean canRestoreBlock() {
        return this.f_19797_ > this.duration && this.m_9236_().m_45976_(Player.class, this.m_20191_()).isEmpty();
    }

    public void m_7380_(CompoundTag compound) {
        BlockState blockState = (BlockState)this.m_20088_().m_135370_(ORIG_BLOCK_STATE);
        compound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        compound.m_128405_("restoreTime", this.getRestoreTime());
        compound.m_128405_("storePosX", this.getStorePos().m_123341_());
        compound.m_128405_("storePosY", this.getStorePos().m_123342_());
        compound.m_128405_("storePosZ", this.getStorePos().m_123343_());
    }

    public void m_7378_(CompoundTag compound) {
        Tag blockNBT = compound.m_128423_("block");
        if (blockNBT != null) {
            BlockState blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)((CompoundTag)blockNBT));
            this.setOrigBlock(blockState);
        }
        this.setRestoreTime(compound.m_128451_("restoreTime"));
        this.setStorePos(new BlockPos(compound.m_128451_("storePosX"), compound.m_128451_("storePosY"), compound.m_128451_("storePosZ")));
    }

    public static class EntityBlockSwapperSculptor
    extends EntityBlockSwapper {
        private int height;
        private int radius;
        private BlockState[][][] origStates;

        public EntityBlockSwapperSculptor(EntityType<? extends EntityBlockSwapperSculptor> type, Level world) {
            super(type, world);
            this.breakParticlesEnd = false;
            this.height = EntitySculptor.TEST_HEIGHT + 3;
            this.radius = EntitySculptor.TEST_RADIUS;
            this.origStates = new BlockState[this.height][this.radius * 2][this.radius * 2];
            this.m_20011_(this.m_142242_());
        }

        public EntityBlockSwapperSculptor(EntityType<? extends EntityBlockSwapperSculptor> type, Level world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
            super(type, world);
            List swappers;
            this.height = EntitySculptor.TEST_HEIGHT + 3;
            this.radius = EntitySculptor.TEST_RADIUS;
            this.origStates = new BlockState[this.height][this.radius * 2][this.radius * 2];
            this.setStorePos(pos);
            this.setRestoreTime(duration);
            this.breakParticlesEnd = breakParticlesEnd;
            this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            this.m_20011_(this.m_142242_());
            List swapperSculptors = world.m_45976_(EntityBlockSwapperSculptor.class, this.m_20191_());
            if (!world.f_46443_) {
                for (int k = 0; k < this.height; ++k) {
                    for (int i = -this.radius; i < this.radius; ++i) {
                        block2: for (int j = -this.radius; j < this.radius; ++j) {
                            BlockPos thisPos = pos.m_7918_(i, k, j);
                            if (!this.isBlockPosInsideSwapper(thisPos) || world.m_8055_(thisPos).m_60734_() == Blocks.f_50752_) continue;
                            this.origStates[k][i + this.radius][j + this.radius] = world.m_8055_(thisPos);
                            if (breakParticlesStart) {
                                world.m_46961_(thisPos, false);
                            }
                            world.m_7731_(thisPos, newBlock, 19);
                            for (EntityBlockSwapperSculptor swapper : swapperSculptors) {
                                if (swapper == this || swapper.getOrigBlockAtLocation(thisPos) == null) continue;
                                this.origStates[k][i + this.radius][j + this.radius] = swapper.getOrigBlockAtLocation(thisPos);
                                continue block2;
                            }
                        }
                    }
                }
            }
            if (!(swappers = world.m_45976_(EntityBlockSwapperSculptor.class, this.m_20191_())).isEmpty()) {
                for (EntityBlockSwapper swapper : swappers) {
                    if (swapper == this || swapper instanceof EntityBlockSwapperSculptor) continue;
                    this.setOrigBlockAtLocation(swapper.getStorePos(), swapper.getOrigBlock());
                }
            }
        }

        @Override
        public boolean isBlockPosInsideSwapper(BlockPos pos) {
            return (double)new Vec2((float)(pos.m_123341_() - this.getStorePos().m_123341_()), (float)(pos.m_123343_() - this.getStorePos().m_123343_())).m_165907_() < EntitySculptor.testRadiusAtHeight((double)pos.m_123342_() - this.m_20186_()) && this.m_20191_().m_82390_(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
        }

        public void setOrigBlockAtLocation(BlockPos pos, BlockState state) {
            if (this.isBlockPosInsideSwapper(pos)) {
                BlockPos indices = this.posToArrayIndices(pos);
                this.origStates[indices.m_123342_()][indices.m_123341_()][indices.m_123343_()] = state;
            }
        }

        public BlockState getOrigBlockAtLocation(BlockPos pos) {
            if (this.isBlockPosInsideSwapper(pos)) {
                BlockPos indices = this.posToArrayIndices(pos);
                return this.origStates[indices.m_123342_()][indices.m_123341_()][indices.m_123343_()];
            }
            return null;
        }

        protected BlockPos posToArrayIndices(BlockPos pos) {
            return pos.m_121996_((Vec3i)this.getStorePos()).m_7918_(this.radius, 0, this.radius);
        }

        protected AABB m_142242_() {
            return EntityDimensions.m_20395_((float)(this.radius * 2), (float)this.height).m_20393_(this.m_20182_());
        }

        @Override
        public void restoreBlock() {
            if (!this.m_9236_().f_46443_) {
                List swappers = this.m_9236_().m_45976_(EntityBlockSwapper.class, this.m_20191_());
                for (int k = 0; k < this.height; ++k) {
                    for (int i = -this.radius; i < this.radius; ++i) {
                        for (int j = -this.radius; j < this.radius; ++j) {
                            BlockState restoreState;
                            BlockPos thisPos;
                            if (this.m_9236_().f_46443_ || !this.isBlockPosInsideSwapper(thisPos = this.getStorePos().m_7918_(i, k, j))) continue;
                            boolean canReplace = true;
                            for (EntityBlockSwapper swapper : swappers) {
                                if (swapper == this || !swapper.isBlockPosInsideSwapper(thisPos)) continue;
                                canReplace = false;
                                break;
                            }
                            if (!canReplace || (restoreState = this.origStates[k][i + this.radius][j + this.radius]) == null) continue;
                            if (this.breakParticlesEnd) {
                                this.m_9236_().m_46961_(thisPos, false);
                            }
                            this.m_9236_().m_7731_(thisPos, restoreState, 19);
                        }
                    }
                }
                this.m_146870_();
            }
        }

        @Override
        protected boolean canRestoreBlock() {
            return this.f_19797_ > this.duration && this.m_9236_().m_6443_(EntitySculptor.class, this.m_20191_(), EntitySculptor::isTesting).isEmpty();
        }

        @Override
        public void m_7380_(CompoundTag compound) {
            compound.m_128405_("restoreTime", this.getRestoreTime());
            compound.m_128405_("storePosX", this.getStorePos().m_123341_());
            compound.m_128405_("storePosY", this.getStorePos().m_123342_());
            compound.m_128405_("storePosZ", this.getStorePos().m_123343_());
            for (int i = 0; i < this.radius * 2; ++i) {
                for (int j = 0; j < this.radius * 2; ++j) {
                    for (int k = 0; k < this.height; ++k) {
                        BlockState block = this.origStates[k][i][j];
                        if (block == null) continue;
                        compound.m_128365_("block_" + i + "_" + j + "_" + k, (Tag)NbtUtils.m_129202_((BlockState)block));
                    }
                }
            }
        }

        @Override
        public void m_7378_(CompoundTag compound) {
            this.setRestoreTime(compound.m_128451_("restoreTime"));
            this.setStorePos(new BlockPos(compound.m_128451_("storePosX"), compound.m_128451_("storePosY"), compound.m_128451_("storePosZ")));
            for (int i = 0; i < this.radius * 2; ++i) {
                for (int j = 0; j < this.radius * 2; ++j) {
                    for (int k = 0; k < this.height; ++k) {
                        BlockState blockState;
                        Tag blockNBT = compound.m_128423_("block_" + i + "_" + j + "_" + k);
                        if (blockNBT == null) continue;
                        this.origStates[k][i][j] = blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)((CompoundTag)blockNBT));
                    }
                }
            }
        }
    }

    public static class EntityBlockSwapperTunneling
    extends EntityBlockSwapper
    implements ILinkedEntity {
        private LivingEntity cachedTunneler;
        private static final EntityDataAccessor<Optional<UUID>> TUNNELER = SynchedEntityData.m_135353_(EntityBlockSwapperTunneling.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

        public EntityBlockSwapperTunneling(EntityType<? extends EntityBlockSwapperTunneling> type, Level world) {
            super(type, world);
        }

        public EntityBlockSwapperTunneling(EntityType<? extends EntityBlockSwapperTunneling> type, Level world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd, LivingEntity tunneler) {
            super(type, world, pos, newBlock, duration, breakParticlesStart, breakParticlesEnd);
            this.cachedTunneler = tunneler;
            if (!world.f_46443_ && tunneler != null) {
                this.setTunnelerID(tunneler.m_20148_());
            }
        }

        public boolean m_6087_() {
            return false;
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.m_20088_().m_135372_(TUNNELER, Optional.empty());
        }

        public Optional<UUID> getTunnelerID() {
            return (Optional)this.m_20088_().m_135370_(TUNNELER);
        }

        public void setTunnelerID(UUID id) {
            this.m_20088_().m_135381_(TUNNELER, Optional.of(id));
        }

        public LivingEntity getTunneler() {
            if (this.cachedTunneler != null && !this.cachedTunneler.m_213877_()) {
                return this.cachedTunneler;
            }
            if (this.getTunnelerID().isPresent() && this.m_9236_() instanceof ServerLevel) {
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.getTunnelerID().get());
                if (entity instanceof LivingEntity) {
                    this.cachedTunneler = (LivingEntity)entity;
                    MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new MessageLinkEntities(this, (Entity)this.cachedTunneler));
                }
                return this.cachedTunneler;
            }
            return null;
        }

        public boolean m_7337_(Entity p_20303_) {
            return super.m_7337_(p_20303_);
        }

        public boolean m_5829_() {
            return true;
        }

        public Entity m_20201_() {
            return this.getTunneler();
        }

        @Override
        public void link(Entity entity) {
            if (entity instanceof LivingEntity) {
                this.cachedTunneler = (LivingEntity)entity;
            }
        }

        @Override
        public void m_7378_(CompoundTag compound) {
            super.m_7378_(compound);
            this.setTunnelerID(compound.m_128342_("tunneler"));
        }

        @Override
        public void m_7380_(CompoundTag compound) {
            super.m_7380_(compound);
            if (this.getTunnelerID().isPresent()) {
                compound.m_128362_("tunneler", this.getTunnelerID().get());
            }
        }

        public Packet<ClientGamePacketListener> m_5654_() {
            LivingEntity entity = this.cachedTunneler;
            return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
        }

        public void m_141965_(ClientboundAddEntityPacket packet) {
            super.m_141965_(packet);
            Entity entity = this.m_9236_().m_6815_(packet.m_131509_());
            if (entity instanceof LivingEntity) {
                this.cachedTunneler = (LivingEntity)entity;
            }
        }
    }
}

