/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Chunk3D
extends ChunkPos {
    public final ResourceKey<Level> dimension;

    public Chunk3D(ResourceKey<Level> dimension, int x, int z) {
        super(x, z);
        this.dimension = dimension;
    }

    public Chunk3D(ResourceKey<Level> dimension, long chunkPos) {
        this(dimension, ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos));
    }

    public Chunk3D(ResourceKey<Level> dimension, ChunkPos chunkPos) {
        this(dimension, chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public Chunk3D(Coord4D coord) {
        this(coord.dimension, SectionPos.m_123171_((int)coord.getX()), SectionPos.m_123171_((int)coord.getZ()));
    }

    public Set<Chunk3D> expand(int chunkRadius) {
        if (chunkRadius < 0) {
            throw new IllegalArgumentException("Chunk radius cannot be negative.");
        }
        if (chunkRadius == 1) {
            return Collections.singleton(this);
        }
        HashSet<Chunk3D> ret = new HashSet<Chunk3D>();
        for (int i = this.f_45578_ - chunkRadius; i <= this.f_45578_ + chunkRadius; ++i) {
            for (int j = this.f_45579_ - chunkRadius; j <= this.f_45579_ + chunkRadius; ++j) {
                ret.add(new Chunk3D(this.dimension, i, j));
            }
        }
        return ret;
    }

    @NotNull
    public String toString() {
        return "[Chunk3D: " + this.f_45578_ + ", " + this.f_45579_ + ", dim=" + String.valueOf(this.dimension.m_135782_()) + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Chunk3D)) return false;
        Chunk3D other = (Chunk3D)((Object)obj);
        if (other.f_45578_ != this.f_45578_) return false;
        if (other.f_45579_ != this.f_45579_) return false;
        if (other.dimension != this.dimension) return false;
        return true;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.f_45578_;
        code = 31 * code + this.f_45579_;
        code = 31 * code + this.dimension.hashCode();
        return code;
    }
}

