/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.auth;

import java.util.Objects;
import org.dynmap.s3lite.api.auth.AwsCredentials;

public class AwsBasicCredentials
implements AwsCredentials {
    private final String accessKey;
    private final String secretKey;

    private AwsBasicCredentials(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public static AwsBasicCredentials create(String accessKey, String secretKey) {
        return new AwsBasicCredentials(accessKey, secretKey);
    }

    @Override
    public String getAWSAccessKeyId() {
        return this.accessKey;
    }

    @Override
    public String getAWSSecretKey() {
        return this.secretKey;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AwsBasicCredentials that = (AwsBasicCredentials)obj;
        return Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessKey, this.secretKey);
    }

    public String toString() {
        return "AwsBasicCredentials{accessKey='" + this.accessKey + '\'' + '}';
    }
}

