/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Lightning_Zap_Particle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private int getR;
    private int getG;
    private int getB;

    protected Lightning_Zap_Particle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites, int r, int g, int b, float gravity) {
        super(level, x, y, z);
        this.f_107226_ = gravity;
        this.f_172258_ = 0.1f;
        this.sprites = sprites;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107227_ = (float)r / 255.0f;
        this.f_107228_ = (float)g / 255.0f;
        this.f_107229_ = (float)b / 255.0f;
        this.getR = r;
        this.getG = g;
        this.getB = b;
        this.f_107663_ = 0.25f + level.f_46441_.m_188501_() * 0.15f;
        this.f_107225_ = 6;
        this.m_108339_(sprites);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float p_106821_) {
        return 240;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107224_ == 3) {
            this.f_107227_ = 1.0f;
            this.f_107228_ = 1.0f;
            this.f_107229_ = 1.0f;
        } else {
            this.f_107227_ = (float)this.getR / 255.0f;
            this.f_107228_ = (float)this.getG / 255.0f;
            this.f_107229_ = (float)this.getB / 255.0f;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
        }
    }

    public static class ZapData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<ZapData> DESERIALIZER = new ParticleOptions.Deserializer<ZapData>(){

            public ZapData fromCommand(ParticleType<ZapData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                float gravity = reader.readFloat();
                return new ZapData(r, g, b, gravity);
            }

            public ZapData fromNetwork(ParticleType<ZapData> particleTypeIn, FriendlyByteBuf buffer) {
                return new ZapData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readFloat());
            }
        };
        private final int r;
        private final int g;
        private final int b;
        private final float gravity;

        public ZapData(int r, int g, int b, float gravity) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.gravity = gravity;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeFloat(this.gravity);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b, Float.valueOf(this.gravity));
        }

        public ParticleType<ZapData> m_6012_() {
            return (ParticleType)ModParticle.LIGHTNING_ZAP.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getGravity() {
            return this.gravity;
        }

        public static Codec<ZapData> CODEC(ParticleType<ZapData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ZapData::getR), (App)Codec.INT.fieldOf("g").forGetter(ZapData::getG), (App)Codec.INT.fieldOf("b").forGetter(ZapData::getB), (App)Codec.FLOAT.fieldOf("gravity").forGetter(ZapData::getGravity)).apply((Applicative)codecBuilder, ZapData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<ZapData> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ZapData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Lightning_Zap_Particle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites, type.getR(), type.getG(), type.getB(), type.getGravity());
        }
    }
}

