/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.commands.hometeleports;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.moo.teleportmod.config.PreferencesConfig;
import com.moo.teleportmod.helpers.SoundManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="teleportcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SetHomeCommand {
    public SetHomeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sethome").requires(ctx -> ctx.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (!((CommandSourceStack)ctx.getSource()).m_81372_().m_5776_()) {
                if (((Boolean)PreferencesConfig.allowHomeCommands.get()).booleanValue()) {
                    this.setHome(player);
                } else {
                    player.m_213846_((Component)Component.m_237119_().m_130946_("This set home command is currently disabled"));
                    SoundManager.playSound(player, SoundEvents.f_11983_);
                }
            }
            return 0;
        }));
    }

    private void setHome(ServerPlayer player) {
        int requiredXP = (Integer)PreferencesConfig.xpToUseSetHomeCommand.get();
        if (player.f_36078_ < requiredXP) {
            player.m_213846_((Component)Component.m_237119_().m_130946_("You need at least " + requiredXP + " experience levels to do this"));
            SoundManager.playSound(player, SoundEvents.f_11983_);
            return;
        }
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        String homeWorld = player.m_284548_().m_46472_().m_135782_().toString();
        player.getPersistentData().m_128347_("teleportcraft:homeXCoord", x);
        player.getPersistentData().m_128347_("teleportcraft:homeYCoord", y);
        player.getPersistentData().m_128347_("teleportcraft:homeZCoord", z);
        player.getPersistentData().m_128359_("teleportcraft:homeWorld", homeWorld);
        player.m_213846_((Component)Component.m_237119_().m_130946_("Home has been set at (x: " + (int)x + ", y: " + (int)y + ", z: " + (int)z + ") in " + player.m_284548_().m_46472_().m_135782_().m_135815_()));
        player.m_9174_(player.f_36078_ - requiredXP);
        SoundManager.playSound(player, SoundEvents.f_12275_);
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        double x = event.getOriginal().getPersistentData().m_128459_("teleportcraft:homeXCoord");
        double y = event.getOriginal().getPersistentData().m_128459_("teleportcraft:homeYCoord");
        double z = event.getOriginal().getPersistentData().m_128459_("teleportcraft:homeZCoord");
        String worldName = event.getOriginal().getPersistentData().m_128461_("teleportcraft:homeWorld");
        Player player = event.getEntity();
        player.getPersistentData().m_128347_("teleportcraft:homeXCoord", x);
        player.getPersistentData().m_128347_("teleportcraft:homeYCoord", y);
        player.getPersistentData().m_128347_("teleportcraft:homeZCoord", z);
        player.getPersistentData().m_128359_("teleportcraft:homeWorld", worldName);
    }
}

