/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.commands.playerteleports;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.moo.teleportmod.TeleportMod;
import com.moo.teleportmod.config.PreferencesConfig;
import com.moo.teleportmod.helpers.SoundManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class TpaAcceptCommand {
    public static String literal = "teleportcraft:accept:tpa";

    public TpaAcceptCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)literal).then(Commands.m_82129_((String)"playerAcceptingRequest", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"playerToTP", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"token", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).requires(ctx -> ctx.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer playerAccepting = EntityArgument.m_91474_((CommandContext)ctx, (String)"playerAcceptingRequest");
            ServerPlayer playerToTP = EntityArgument.m_91474_((CommandContext)ctx, (String)"playerToTP");
            String token = StringArgumentType.getString((CommandContext)ctx, (String)"token");
            long time = Long.parseLong(StringArgumentType.getString((CommandContext)ctx, (String)"time"));
            if (!((CommandSourceStack)ctx.getSource()).m_81372_().m_5776_() && ((Boolean)PreferencesConfig.allowTPACommand.get()).booleanValue() && token.equals(TeleportMod.token) && playerAccepting.m_20148_() == ((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_()) {
                this.acceptTpa(playerAccepting, playerToTP, time);
            }
            return 0;
        }))))));
    }

    private void acceptTpa(ServerPlayer playerAccepting, ServerPlayer playerToTP, long time) {
        boolean foundRequest = false;
        for (String tag : playerToTP.getPersistentData().m_128431_()) {
            String[] components = tag.split(" ");
            if (components.length != 2 || !components[0].equals("teleportcraft:activeTpaRequestTime") || !components[1].equals(playerAccepting.m_20148_().toString()) || playerToTP.getPersistentData().m_128454_(tag) != time) continue;
            foundRequest = true;
            break;
        }
        if (!foundRequest) {
            return;
        }
        MutableComponent playerAcceptingMsg = Component.m_237119_();
        MutableComponent playerToTPName = Component.m_237119_().m_130946_(playerToTP.m_7755_().getString());
        playerToTPName.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131136_(Boolean.valueOf(true)));
        MutableComponent playerAcceptingContent = Component.m_237119_().m_130946_(" is on their way to you");
        playerAcceptingMsg.m_7360_().add(playerToTPName);
        playerAcceptingMsg.m_7360_().add(playerAcceptingContent);
        playerAccepting.m_213846_((Component)playerAcceptingMsg);
        SoundManager.playSound(playerAccepting, SoundEvents.f_12275_);
        MutableComponent playerToTPMsg = Component.m_237119_();
        MutableComponent playerAcceptingName = Component.m_237119_().m_130946_(playerAccepting.m_7755_().getString());
        playerAcceptingName.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131136_(Boolean.valueOf(true)));
        MutableComponent playerToTPContent = Component.m_237119_().m_130946_(" has accepted your teleport request\nTeleporting now ...");
        playerToTPMsg.m_7360_().add(playerAcceptingName);
        playerToTPMsg.m_7360_().add(playerToTPContent);
        playerToTP.m_213846_((Component)playerToTPMsg);
        EntityTeleportEvent.TeleportCommand event = new EntityTeleportEvent.TeleportCommand((Entity)playerToTP, playerAccepting.m_20185_(), playerAccepting.m_20186_(), playerAccepting.m_20189_());
        MinecraftForge.EVENT_BUS.post((Event)event);
        ServerLevel targetWorld = playerAccepting.m_284548_();
        playerToTP.m_8999_(targetWorld, playerAccepting.m_20185_(), playerAccepting.m_20186_(), playerAccepting.m_20189_(), playerAccepting.m_146908_(), playerAccepting.m_146909_());
        SoundManager.playSound(playerToTP, SoundEvents.f_11852_);
        playerToTP.getPersistentData().m_128473_("teleportcraft:activeTpaRequestTime " + playerAccepting.m_20148_());
    }
}

