/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.commands.playerteleports;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.moo.teleportmod.TeleportMod;
import com.moo.teleportmod.commands.playerteleports.TpaAcceptCommand;
import com.moo.teleportmod.commands.playerteleports.TpaDeclineCommand;
import com.moo.teleportmod.config.PreferencesConfig;
import com.moo.teleportmod.helpers.SoundManager;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="teleportcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TpaCommand {
    public static long expirationTime = 60L;

    public TpaCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tpa").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).requires(ctx -> ctx.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer sourcePlayer = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerPlayer targetPlayer = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            if (!((CommandSourceStack)ctx.getSource()).m_81372_().m_5776_()) {
                if (((Boolean)PreferencesConfig.allowTPACommand.get()).booleanValue()) {
                    expirationTime = (Long)PreferencesConfig.TPAExpiration.get();
                    this.sendTpaMessage(sourcePlayer, targetPlayer);
                } else {
                    sourcePlayer.m_213846_((Component)Component.m_237119_().m_130946_("This tpa command is currently disabled"));
                    SoundManager.playSound(sourcePlayer, SoundEvents.f_11983_);
                }
            }
            return 0;
        })));
    }

    private void sendTpaMessage(ServerPlayer source, ServerPlayer target) {
        if (source.m_20148_().equals(target.m_20148_())) {
            source.m_213846_((Component)Component.m_237119_().m_130946_("You cannot send a tpa request to yourself"));
            SoundManager.playSound(source, SoundEvents.f_11983_);
            return;
        }
        int requiredXP = (Integer)PreferencesConfig.xpToUseTPACommand.get();
        if (source.f_36078_ < requiredXP) {
            source.m_213846_((Component)Component.m_237119_().m_130946_("You need at least " + requiredXP + " experience levels to do this"));
            SoundManager.playSound(source, SoundEvents.f_11983_);
            return;
        }
        for (String tag : source.getPersistentData().m_128431_()) {
            String[] components = tag.split(" ");
            if (components.length != 2 || !components[0].equals("teleportcraft:activeTpaRequestTime") || !components[1].equals(target.m_20148_().toString())) continue;
            long timeLeft = expirationTime - (System.currentTimeMillis() / 1000L - source.getPersistentData().m_128454_(tag));
            if (timeLeft < 0L) {
                timeLeft = 0L;
            }
            source.m_213846_((Component)Component.m_237119_().m_130946_("You must wait " + timeLeft + " seconds before sending another request to that player"));
            SoundManager.playSound(source, SoundEvents.f_11983_);
            return;
        }
        MutableComponent sourceMsg = Component.m_237119_().m_130946_("Teleport request sent to ");
        sourceMsg.m_6270_(Style.f_131099_);
        MutableComponent targetName = Component.m_237119_().m_130946_(target.m_7755_().getString());
        targetName.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131136_(Boolean.valueOf(true)));
        sourceMsg.m_7360_().add(targetName);
        source.m_213846_((Component)sourceMsg);
        source.m_9174_(source.f_36078_ - requiredXP);
        SoundManager.playSound(source, SoundEvents.f_11857_);
        MutableComponent targetMsg = Component.m_237119_();
        MutableComponent sourceName = Component.m_237119_().m_130946_(source.m_7755_().getString());
        sourceName.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131136_(Boolean.valueOf(true)));
        MutableComponent announcement = Component.m_237119_().m_130946_(" would like to teleport to you\n");
        targetMsg.m_7360_().add(sourceName);
        targetMsg.m_7360_().add(announcement);
        MutableComponent accept = Component.m_237119_().m_130946_("Accept");
        MutableComponent acceptHoverMsg = Component.m_237119_().m_130946_("Click to Accept");
        HoverEvent acceptHover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)acceptHoverMsg);
        ClickEvent acceptClick = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + TpaAcceptCommand.literal + " " + target.m_7755_().getString() + " " + source.m_7755_().getString() + " " + TeleportMod.token + " " + System.currentTimeMillis() / 1000L);
        accept.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131144_(acceptHover).m_131142_(acceptClick));
        targetMsg.m_7360_().add(accept);
        MutableComponent space = Component.m_237119_().m_130946_(" ");
        targetMsg.m_7360_().add(space);
        MutableComponent decline = Component.m_237119_().m_130946_("Decline");
        MutableComponent declineHoverMsg = Component.m_237119_().m_130946_("Click to Decline");
        HoverEvent declineHover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)declineHoverMsg);
        ClickEvent declineClick = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + TpaDeclineCommand.literal + " " + target.m_7755_().getString() + " " + source.m_7755_().getString() + " " + TeleportMod.token + " " + System.currentTimeMillis() / 1000L);
        decline.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131144_(declineHover).m_131142_(declineClick));
        targetMsg.m_7360_().add(decline);
        long time = System.currentTimeMillis() / 1000L;
        source.getPersistentData().m_128356_("teleportcraft:activeTpaRequestTime " + target.m_20148_(), time);
        target.m_213846_((Component)targetMsg);
        SoundManager.playSound(target, SoundEvents.f_11871_);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            Iterator iterator = player.getPersistentData().m_128431_().iterator();
            while (iterator.hasNext()) {
                String tag = (String)iterator.next();
                String[] components = tag.split(" ");
                if (components.length != 2 || !components[0].equals("teleportcraft:activeTpaRequestTime") || System.currentTimeMillis() / 1000L - player.getPersistentData().m_128454_(tag) <= expirationTime) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player originalPlayer = event.getOriginal();
        Player player = event.getEntity();
        for (String tag : originalPlayer.getPersistentData().m_128431_()) {
            String[] components = tag.split(" ");
            if (components.length != 2 || !components[0].equals("teleportcraft:activeTpaRequestTime")) continue;
            long data = originalPlayer.getPersistentData().m_128454_(tag);
            player.getPersistentData().m_128356_(tag, data);
        }
    }
}

