/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.commands.playerteleports;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.moo.teleportmod.TeleportMod;
import com.moo.teleportmod.config.PreferencesConfig;
import com.moo.teleportmod.helpers.SoundManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;

public class TpaDeclineCommand {
    public static String literal = "teleportcraft:decline:tpa";

    public TpaDeclineCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)literal).then(Commands.m_82129_((String)"playerDecliningRequest", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"playerToNotTP", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"token", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).requires(ctx -> ctx.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer playerDeclining = EntityArgument.m_91474_((CommandContext)ctx, (String)"playerDecliningRequest");
            ServerPlayer playerToNotTP = EntityArgument.m_91474_((CommandContext)ctx, (String)"playerToNotTP");
            String token = StringArgumentType.getString((CommandContext)ctx, (String)"token");
            long time = Long.parseLong(StringArgumentType.getString((CommandContext)ctx, (String)"time"));
            if (!((CommandSourceStack)ctx.getSource()).m_81372_().m_5776_() && ((Boolean)PreferencesConfig.allowTPACommand.get()).booleanValue() && token.equals(TeleportMod.token) && playerDeclining.m_20148_() == ((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_()) {
                this.declineTpa(playerDeclining, playerToNotTP, time);
            }
            return 0;
        }))))));
    }

    private void declineTpa(ServerPlayer playerDeclining, ServerPlayer playerToNotTP, long time) {
        boolean foundRequest = false;
        for (String tag : playerToNotTP.getPersistentData().m_128431_()) {
            String[] components = tag.split(" ");
            if (components.length != 2 || !components[0].equals("teleportcraft:activeTpaRequestTime") || !components[1].equals(playerDeclining.m_20148_().toString()) || playerToNotTP.getPersistentData().m_128454_(tag) != time) continue;
            foundRequest = true;
            break;
        }
        if (!foundRequest) {
            return;
        }
        MutableComponent playerDecliningMsg = Component.m_237119_();
        MutableComponent playerToNotTPName = Component.m_237119_().m_130946_(playerToNotTP.m_7755_().getString());
        playerToNotTPName.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131136_(Boolean.valueOf(true)));
        MutableComponent playerDecliningContent = Component.m_237119_().m_130946_(" will not be teleported to you");
        playerDecliningMsg.m_7360_().add(playerToNotTPName);
        playerDecliningMsg.m_7360_().add(playerDecliningContent);
        playerDeclining.m_213846_((Component)playerDecliningMsg);
        SoundManager.playSound(playerDeclining, SoundEvents.f_12275_);
        MutableComponent playerToNotTPMsg = Component.m_237119_();
        MutableComponent playerDecliningName = Component.m_237119_().m_130946_(playerDeclining.m_7755_().getString());
        playerDecliningName.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131136_(Boolean.valueOf(true)));
        MutableComponent playerToNotTPContent = Component.m_237119_().m_130946_(" has declined your teleport request");
        playerToNotTPMsg.m_7360_().add(playerDecliningName);
        playerToNotTPMsg.m_7360_().add(playerToNotTPContent);
        playerToNotTP.m_213846_((Component)playerToNotTPMsg);
        SoundManager.playSound(playerToNotTP, SoundEvents.f_11983_);
        playerToNotTP.getPersistentData().m_128473_("teleportcraft:activeTpaRequestTime " + playerDeclining.m_20148_());
    }
}

