/*
 * Decompiled with CFR 0.152.
 */
package com.moo.teleportmod.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class PreferencesConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.BooleanValue allowBackCommand;
    public static final ForgeConfigSpec.BooleanValue allowGraveCommand;
    public static final ForgeConfigSpec.BooleanValue allowHomeCommands;
    public static final ForgeConfigSpec.BooleanValue allowTPACommand;
    public static final ForgeConfigSpec.LongValue TPAExpiration;
    public static final ForgeConfigSpec.IntValue xpToUseBackCommand;
    public static final ForgeConfigSpec.IntValue xpToUseSetHomeCommand;
    public static final ForgeConfigSpec.IntValue xpToUseHomeCommand;
    public static final ForgeConfigSpec.IntValue xpToUseGraveCommand;
    public static final ForgeConfigSpec.IntValue xpToUseTPACommand;
    public static final ForgeConfigSpec.IntValue permissionLevelToUpdate;

    public static String getFileName() {
        return "teleportcraft-preferences.toml";
    }

    public static String getRelativePath() {
        return "teleportcraft/" + PreferencesConfig.getFileName();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.comment("User-adjustable Preferences").push("preferences");
        allowBackCommand = BUILDER.comment("After teleporting, players can teleport back to where they came from (true or false)").define("allowBackCommand", true);
        allowHomeCommands = BUILDER.comment("Players can set and teleport home (true or false)").define("allowHomeCommands", true);
        allowGraveCommand = BUILDER.comment("Players can teleport to their most recent death point (true or false)").define("allowGraveCommand", true);
        allowTPACommand = BUILDER.comment("Players can request to teleport to other players (true or false)").define("allowTPACommand", true);
        TPAExpiration = BUILDER.comment("The amount of time it takes a request to expire (seconds)\nNumber must be a whole number, not a decimal").defineInRange("TPAExpiration", 60L, 0L, 1000000000L);
        xpToUseBackCommand = BUILDER.comment("The amount of xp levels consumed when using back command\nNumber must be a whole number, not a decimal").defineInRange("xpToUseBackCommand", 0, 0, 1000000000);
        xpToUseSetHomeCommand = BUILDER.comment("The amount of xp levels consumed when using sethome command\nNumber must be a whole number, not a decimal").defineInRange("xpToUseSetHomeCommand", 0, 0, 1000000000);
        xpToUseHomeCommand = BUILDER.comment("The amount of xp levels consumed when using home command\nNumber must be a whole number, not a decimal").defineInRange("xpToUseHomeCommand", 0, 0, 1000000000);
        xpToUseGraveCommand = BUILDER.comment("The amount of xp levels consumed when using grave command\nNumber must be a whole number, not a decimal").defineInRange("xpToUseGraveCommand", 0, 0, 1000000000);
        xpToUseTPACommand = BUILDER.comment("The amount of xp levels consumed when using tpa command\nNumber must be a whole number, not a decimal").defineInRange("xpToUseTPACommand", 0, 0, 1000000000);
        permissionLevelToUpdate = BUILDER.comment("The permission level needed to use the update command (usually 4 is owner, 3 is admin, 2 is gamemaster, 1 is mod, and 0 is anybody)\nNumber must be a whole number, not a decimal").defineInRange("permissionLevelToUpdate", 4, 0, 1000000000);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

