/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.bk.entity;

import com.google.common.collect.ImmutableSet;
import com.lupicus.bk.item.ModItems;
import com.lupicus.bk.sound.ModSounds;
import com.lupicus.bk.village.ModPOI;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.registries.IForgeRegistry;

public class ModProfessions {
    public static final VillagerProfession BEEKEEPER = ModProfessions.create("beekeeper", ModPOI.BEEKEEPER_KEY, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of((Object)Blocks.f_50718_), ModSounds.ENTITY_VILLAGER_WORK_BEEKEEPER);
    private static Constructor<?> ctr1 = null;
    private static Constructor<?> ctr2 = null;

    private static VillagerProfession create(String key, ResourceKey<PoiType> type, SoundEvent event) {
        return ModProfessions.create(key, type, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), event);
    }

    private static VillagerProfession create(String key, ResourceKey<PoiType> type, ImmutableSet<Item> items, ImmutableSet<Block> blocks, SoundEvent event) {
        Predicate<Holder> pred = h -> h.m_203565_(type);
        return new VillagerProfession(key, pred, pred, items, blocks, event);
    }

    public static void register(IForgeRegistry<VillagerProfession> registry) {
        registry.register(ModProfessions.makeKey(BEEKEEPER), (Object)BEEKEEPER);
        ModProfessions.setupTrades();
        ModProfessions.setupLoot();
    }

    private static ResourceLocation makeKey(VillagerProfession prof) {
        return new ResourceLocation("bk", prof.f_35600_());
    }

    static void setupTrades() {
        ModProfessions.findConstructors();
        Int2ObjectArrayMap bk = new Int2ObjectArrayMap();
        VillagerTrades.ItemListing[] value = new VillagerTrades.ItemListing[]{ModProfessions.EmeraldForItemsTrade(Items.f_42787_, 4, 8, 2), ModProfessions.EmeraldForItemsTrade(Items.f_41837_, 12, 8, 2), ModProfessions.EmeraldForItemsTrade(Items.f_41839_, 12, 8, 2), ModProfessions.ItemsForEmeraldsTrade(Items.f_42786_, 1, 1, 2), ModProfessions.ItemsForEmeraldsTrade(Items.f_42000_, 1, 16, 1)};
        bk.put(1, (Object)value);
        value = new VillagerTrades.ItemListing[]{ModProfessions.EmeraldForItemsTrade(Items.f_42206_, 18, 8, 4), ModProfessions.ItemsForEmeraldsTrade(Items.f_42781_, 2, 1, 5), ModProfessions.ItemsForEmeraldsTrade(Items.f_42574_, 3, 1, 4), ModProfessions.ItemsForEmeraldsTrade(Items.f_41944_, 1, 10, 6), ModProfessions.ItemsForEmeraldsTrade(Items.f_41945_, 1, 10, 6)};
        bk.put(2, (Object)value);
        value = new VillagerTrades.ItemListing[]{ModProfessions.EmeraldForItemsTrade(Items.f_42590_, 9, 8, 9), ModProfessions.EmeraldForItemsTrade(Items.f_42784_, 3, 8, 6), ModProfessions.ItemsForEmeraldsTrade(ModItems.BEE_POLLEN, 1, 1, 9)};
        bk.put(3, (Object)value);
        value = new VillagerTrades.ItemListing[]{ModProfessions.EmeraldForItemsTrade(Items.f_41941_, 9, 8, 12), ModProfessions.ItemsForEmeraldsTrade(Items.f_42548_, 10, 1, 13)};
        bk.put(4, (Object)value);
        value = new VillagerTrades.ItemListing[]{ModProfessions.EmeraldForItemsTrade(Items.f_41942_, 9, 8, 4), ModProfessions.ItemsForEmeraldsTrade(ModItems.ROYAL_JELLY, 5, 1, 5)};
        bk.put(5, (Object)value);
        VillagerTrades.f_35627_.put(BEEKEEPER, bk);
    }

    private static void findConstructors() {
        for (Class<?> c : VillagerTrades.class.getDeclaredClasses()) {
            if (c.getName().endsWith("$EmeraldForItems")) {
                try {
                    ctr1 = c.getDeclaredConstructor(ItemLike.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    ctr1.setAccessible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!c.getName().endsWith("$ItemsForEmeralds")) continue;
            try {
                ctr2 = c.getDeclaredConstructor(Item.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                ctr2.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static VillagerTrades.ItemListing EmeraldForItemsTrade(Item item, int count, int maxUses, int xpValue) {
        VillagerTrades.ItemListing ret = null;
        try {
            ret = (VillagerTrades.ItemListing)ctr1.newInstance(item, count, maxUses, xpValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static VillagerTrades.ItemListing ItemsForEmeraldsTrade(Item item, int cost, int count, int xpValue) {
        VillagerTrades.ItemListing ret = null;
        try {
            ret = (VillagerTrades.ItemListing)ctr2.newInstance(item, cost, count, xpValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static void setupLoot() {
        try {
            String name = ASMAPI.mapField((String)"f_147550_");
            Field field = GiveGiftToHero.class.getDeclaredField(name);
            field.setAccessible(true);
            Map value = (Map)field.get(null);
            value.put(BEEKEEPER, new ResourceLocation("bk", "gameplay/hero_of_the_village/beekeeper_gift"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

