/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class SitAndLookGoal
extends Goal {
    private static final int MIN_REST_TIME = 60;
    private static final int MAX_REST_TIME = 200;
    private static final double LOOK_RANGE = 8.0;
    private final AbstractGoblinEntity goblin;
    private final TargetingConditions conditions;
    private int timeout;
    @Nullable
    protected Entity focusAt;

    public SitAndLookGoal(AbstractGoblinEntity goblin) {
        this.goblin = goblin;
        this.conditions = TargetingConditions.m_148353_().m_26883_(8.0);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.goblin.isSitting()) {
            return false;
        }
        return this.goblin.m_217043_().m_188503_(200) == 0;
    }

    public boolean m_8045_() {
        return !this.goblin.isStunned() && this.goblin.isSitting() && this.timeout > 0;
    }

    public void m_8056_() {
        this.goblin.setSitting(true);
        this.timeout = this.goblin.m_217043_().m_216332_(60, 200);
    }

    public void m_8041_() {
        this.goblin.setSitting(false);
        this.goblin.setCurious(false);
        this.focusAt = null;
    }

    public void m_8037_() {
        --this.timeout;
        if (this.focusAt != null) {
            if (!this.goblin.isCurious() && this.goblin.m_217043_().m_188501_() < 0.05f) {
                this.goblin.setCurious(true);
            }
        } else if (this.goblin.isCurious()) {
            this.goblin.setCurious(false);
        }
        this.updateFocusTarget();
        if (this.focusAt != null) {
            this.goblin.m_21563_().m_24946_(this.focusAt.m_20185_(), this.focusAt.m_20188_(), this.focusAt.m_20189_());
        }
    }

    private void updateFocusTarget() {
        if (this.focusAt == null) {
            if (this.goblin.m_217043_().m_188501_() >= 0.05f) {
                return;
            }
            Level level = this.goblin.m_9236_();
            this.focusAt = level.m_45982_(level.m_6443_(LivingEntity.class, this.goblin.m_20191_().m_82377_(8.0, 3.0, 8.0), v -> true), this.conditions, (LivingEntity)this.goblin, this.goblin.m_20185_(), this.goblin.m_20188_(), this.goblin.m_20189_());
        }
        if (this.focusAt != null && (!this.focusAt.m_6084_() || this.focusAt.m_20280_((Entity)this.goblin) > 64.0)) {
            this.focusAt = null;
        }
    }
}

