/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.Constants;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.TradeSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;

public class TradeManager
implements PreparableReloadListener {
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON = new GsonBuilder().create();
    private static TradeManager instance;
    private final List<EntityType<?>> traders = new ArrayList();
    private final Map<ResourceLocation, TradeSerializer<?>> serializers = new HashMap();
    private Map<EntityType<?>, EntityTrades> entityToTrades = new HashMap();

    public static TradeManager instance() {
        if (instance == null) {
            instance = new TradeManager();
        }
        return instance;
    }

    public void registerTrader(EntityType<? extends TraderCreatureEntity> type) {
        if (!this.traders.contains(type)) {
            this.traders.add(type);
        }
    }

    @Nullable
    public EntityTrades getTrades(EntityType<? extends TraderCreatureEntity> type) {
        return this.entityToTrades.get(type);
    }

    public void registerTypeSerializer(TradeSerializer<?> serializer) {
        this.serializers.putIfAbsent(serializer.getId(), serializer);
    }

    @Nullable
    public TradeSerializer<?> getTypeSerializer(ResourceLocation id) {
        return this.serializers.get(id);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        HashMap entityToResourceList = new HashMap();
        return CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.traders.forEach(entityType -> {
            String folder = String.format("trades/%s", EntityType.m_20613_((EntityType)entityType).m_135815_());
            ArrayList resources = new ArrayList(manager.m_214159_(folder, fileName -> fileName.m_135815_().endsWith(".json")).keySet());
            resources.sort((r1, r2) -> {
                if (r1.m_135827_().equals(r2.m_135827_())) {
                    return 0;
                }
                return r2.m_135827_().equals("goblintraders") ? 1 : -1;
            });
            EnumMap tradeResources = new EnumMap(TradeRarity.class);
            Arrays.stream(TradeRarity.values()).forEach(rarity -> tradeResources.put((TradeRarity)((Object)((Object)((Object)rarity))), new LinkedHashSet()));
            resources.forEach(resource -> {
                String path = resource.m_135815_().substring(0, resource.m_135815_().length() - FILE_TYPE_LENGTH_VALUE);
                String[] splitPath = path.split("/");
                if (splitPath.length != 3) {
                    return;
                }
                Arrays.stream(TradeRarity.values()).forEach(rarity -> {
                    if (rarity.getKey().equals(splitPath[2])) {
                        ((LinkedHashSet)tradeResources.get(rarity)).add(resource);
                    }
                });
            });
            EntityTrades.Builder builder = EntityTrades.Builder.create();
            Arrays.stream(TradeRarity.values()).forEach(rarity -> this.deserializeTrades(manager, builder, (TradeRarity)((Object)((Object)((Object)rarity))), (LinkedHashSet)tradeResources.get(rarity)));
            entityToResourceList.put(entityType, builder.build());
            this.entityToTrades = ImmutableMap.copyOf((Map)entityToResourceList);
        }), backgroundExecutor)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
    }

    private void deserializeTrades(ResourceManager manager, EntityTrades.Builder builder, TradeRarity rarity, LinkedHashSet<ResourceLocation> resources) {
        for (ResourceLocation resourceLocation : resources) {
            manager.m_213713_(resourceLocation).ifPresent(resource -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8));){
                    JsonObject object = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    builder.deserialize(rarity, object);
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to load trade file: " + String.valueOf(resourceLocation));
                }
            });
        }
    }
}

