/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.hostile;

import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class ArtificialGolemModel<T extends ArtificialGolemEntity>
extends ListModel<T>
implements ArmedModel {
    protected final ModelPart body;
    protected final ModelPart leftArm;
    protected final ModelPart rightArm;
    protected final ModelPart cannonConnection;
    protected final ModelPart head;
    protected final ModelPart nose;
    protected final ModelPart rightHornTop;
    protected final ModelPart rightHornBottom;
    protected final ModelPart leftHornTop;
    protected final ModelPart leftHornBottom;
    protected final ModelPart leftLeg;
    protected final ModelPart rightLeg;

    public ArtificialGolemModel(ModelPart model) {
        this.body = model.m_171324_("body");
        this.head = model.m_171324_("head");
        this.nose = this.head.m_171324_("nose");
        this.rightHornBottom = this.head.m_171324_("right_horn_bottom");
        this.rightHornTop = this.head.m_171324_("right_horn_top");
        this.leftHornBottom = this.head.m_171324_("left_horn_bottom");
        this.leftHornTop = this.head.m_171324_("left_horn_top");
        this.rightArm = model.m_171324_("right_arm");
        this.cannonConnection = this.rightArm.m_171324_("cannon_connection");
        this.leftArm = model.m_171324_("left_arm");
        this.rightLeg = model.m_171324_("right_leg");
        this.leftLeg = model.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(-6.5f, -1.8f, -3.0f, 13.0f, 12.0f, 6.0f, size), PartPose.m_171419_((float)0.0f, (float)1.8f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 2).m_171480_().m_171488_(-1.0f, -5.1f, -4.0f, 2.0f, 4.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)2.1f, (float)-2.0f));
        head.m_171599_("right_horn_bottom", CubeListBuilder.m_171558_().m_171514_(33, 9).m_171488_(-8.0f, -10.1f, 1.0f, 4.0f, 2.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)2.1f, (float)-2.0f));
        head.m_171599_("right_horn_top", CubeListBuilder.m_171558_().m_171514_(33, 3).m_171488_(-8.0f, -13.1f, 1.0f, 2.0f, 3.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)2.1f, (float)-2.0f));
        head.m_171599_("left_horn_bottom", CubeListBuilder.m_171558_().m_171514_(33, 9).m_171488_(4.0f, -10.1f, 1.0f, 4.0f, 2.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)2.1f, (float)-2.0f));
        head.m_171599_("left_horn_top", CubeListBuilder.m_171558_().m_171514_(33, 3).m_171488_(6.0f, -13.1f, 1.0f, 2.0f, 3.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)2.1f, (float)-2.0f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(38, 19).m_171480_().m_171488_(-4.5f, -1.5f, -1.0f, 4.0f, 15.0f, 4.0f, size), PartPose.m_171419_((float)-6.0f, (float)1.5f, (float)-1.0f));
        rightArm.m_171599_("cannon_connection", CubeListBuilder.m_171558_().m_171514_(17, 23).m_171488_(-11.0f, -19.0f, -2.5f, 5.0f, 9.0f, 5.0f, size), PartPose.m_171419_((float)6.0f, (float)22.5f, (float)1.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(0.5f, -1.5f, -1.0f, 4.0f, 15.0f, 4.0f, size), PartPose.m_171419_((float)6.0f, (float)1.5f, (float)-1.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(39, 41).m_171480_().m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, size), PartPose.m_171419_((float)-2.5f, (float)12.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(39, 41).m_171488_(-3.5f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, size), PartPose.m_171419_((float)5.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public Iterable<ModelPart> m_6195_() {
        return List.of(this.body, this.leftArm, this.rightArm, this.head, this.leftLeg, this.rightLeg);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int i = ((ArtificialGolemEntity)entityIn).getAttackTimer();
        this.head.f_104203_ = headPitch / 57.29578f;
        this.head.f_104204_ = netHeadYaw / 57.29578f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (((ArtificialGolemEntity)entityIn).isRanged() && ((ArtificialGolemEntity)entityIn).getAttacking()) {
            this.rightArm.f_104203_ = this.head.f_104203_ + -1.5f;
            this.rightArm.f_104204_ = this.head.f_104204_;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.leftArm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            return;
        }
        if (i <= 0) {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 3.141593f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.leftArm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.rightArm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftArm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            return;
        }
    }

    public void prepareMobModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (((ArtificialGolemEntity)entitylivingbaseIn).isRanged()) {
            return;
        }
        int i = ((ArtificialGolemEntity)entitylivingbaseIn).getAttackTimer();
        if (i > 0) {
            this.rightArm.f_104203_ = -2.0f + 1.5f * this.triangleWave((float)i - partialTickTime, 10.0f);
            this.leftArm.f_104203_ = -2.0f + 1.5f * this.triangleWave((float)i - partialTickTime, 10.0f);
        }
    }

    private float triangleWave(float p_78172_1_, float p_78172_2_) {
        return (Math.abs(p_78172_1_ % p_78172_2_ - p_78172_2_ * 0.5f) - p_78172_2_ * 0.25f) / (p_78172_2_ * 0.25f);
    }

    public void m_6002_(HumanoidArm side, PoseStack matrix) {
        this.getArmForSide(side).m_104299_(matrix);
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.leftArm : this.leftArm;
    }
}

