/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.client.gui.merchant.AbstractPaintingMerchantWidget;
import me.dantaeusb.zettergallery.client.gui.merchant.AuthWidget;
import me.dantaeusb.zettergallery.client.gui.merchant.OfferInfoWidget;
import me.dantaeusb.zettergallery.client.gui.merchant.PaginatorWidget;
import me.dantaeusb.zettergallery.client.gui.merchant.PaintingPreviewWidget;
import me.dantaeusb.zettergallery.client.gui.merchant.RefreshWidget;
import me.dantaeusb.zettergallery.container.PaintingMerchantContainer;
import me.dantaeusb.zettergallery.core.ClientHelper;
import me.dantaeusb.zettergallery.core.ZetterGalleryNetwork;
import me.dantaeusb.zettergallery.gallery.AuthorizationCode;
import me.dantaeusb.zettergallery.gallery.PlayerToken;
import me.dantaeusb.zettergallery.menu.PaintingMerchantMenu;
import me.dantaeusb.zettergallery.menu.paintingmerchant.MerchantAuthorizationController;
import me.dantaeusb.zettergallery.network.packet.CFeedRefreshRequest;
import me.dantaeusb.zettergallery.trading.PaintingMerchantOffer;
import me.dantaeusb.zettergallery.trading.PaintingMerchantSaleOffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PaintingMerchantScreen
extends AbstractContainerScreen<PaintingMerchantMenu> {
    public static final ResourceLocation PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE = new ResourceLocation("zettergallery", "textures/gui/painting_trade.png");
    private static final Component LEVEL_SEPARATOR = Component.m_237113_((String)" - ");
    private AuthWidget authWidget;
    private PaintingPreviewWidget previewWidget;
    private PaginatorWidget paginatorWidget;
    private OfferInfoWidget infoWidget;
    private RefreshWidget refreshWidget;
    private final List<AbstractPaintingMerchantWidget> paintingMerchantWidgets = Lists.newArrayList();
    private int tick = 0;
    private boolean waitingForBrowser = false;
    private boolean waitingForAuth = false;
    static final int AUTH_POSITION_X = 6;
    static final int AUTH_POSITION_Y = 114;
    static final int PREVIEW_POSITION_X = 11;
    static final int PREVIEW_POSITION_Y = 30;
    static final int PAGINATOR_POSITION_X = 83;
    static final int PAGINATOR_POSITION_Y = 100;
    static final int INFO_POSITION_X = 6;
    static final int INFO_POSITION_Y = 26;
    static final int REFRESH_POSITION_X = 156;
    static final int REFRESH_POSITION_Y = 5;
    private static final int COUNT_X = 44;
    private static final int COUNT_Y = 97;

    public PaintingMerchantScreen(PaintingMerchantMenu merchantContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)merchantContainer, playerInventory, title);
        this.f_97727_ = 236;
        this.f_97726_ = 208;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.authWidget = new AuthWidget(this, this.getGuiLeft() + 6, this.getGuiTop() + 114);
        this.previewWidget = new PaintingPreviewWidget(this, this.getGuiLeft() + 11, this.getGuiTop() + 30);
        this.paginatorWidget = new PaginatorWidget(this, this.getGuiLeft() + 83, this.getGuiTop() + 100);
        this.infoWidget = new OfferInfoWidget(this, this.getGuiLeft() + 6, this.getGuiTop() + 26);
        this.refreshWidget = new RefreshWidget(this, this.getGuiLeft() + 156, this.getGuiTop() + 5);
        this.addPaintingMerchantWidget(this.authWidget);
        this.addPaintingMerchantWidget(this.previewWidget);
        this.addPaintingMerchantWidget(this.paginatorWidget);
        this.addPaintingMerchantWidget(this.infoWidget);
        this.addPaintingMerchantWidget(this.refreshWidget);
        this.f_97730_ = 107;
    }

    protected void m_169413_() {
        super.m_169413_();
        this.paintingMerchantWidgets.clear();
    }

    public void addPaintingMerchantWidget(AbstractPaintingMerchantWidget widget) {
        this.paintingMerchantWidgets.add(widget);
        this.m_7787_(widget);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_181908_() {
        super.m_181908_();
        ++this.tick;
        if (this.waitingForBrowser && !Minecraft.m_91087_().m_91302_()) {
            this.waitingForAuth = true;
            this.waitingForBrowser = false;
        }
        if (this.waitingForAuth && Minecraft.m_91087_().m_91302_()) {
            ((PaintingMerchantMenu)this.f_97732_).getAuthController().handleAuthorizationRetry();
            this.waitingForAuth = false;
        }
        this.authWidget.tick();
        this.previewWidget.tick();
        this.infoWidget.tick();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderProgressBar(guiGraphics);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        for (AbstractPaintingMerchantWidget widget : this.paintingMerchantWidgets) {
            if (!widget.m_5953_(x, y)) continue;
            widget.renderTooltip(guiGraphics, x, y);
        }
    }

    private void renderProgressBar(GuiGraphics guiGraphics) {
        float BAR_U = 0.0f;
        float BAR_V = 246.0f;
        int BAR_WIDTH = 102;
        int BAR_HEIGHT = 5;
        int xPos = this.f_97735_ + 6;
        int yPos = this.f_97736_ + 16;
        int merchantLevel = ((PaintingMerchantMenu)this.f_97732_).getMerchantLevel();
        int merchantXp = ((PaintingMerchantMenu)this.f_97732_).getMerchant().m_7809_();
        if (merchantLevel < 5) {
            guiGraphics.m_280163_(PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, xPos, yPos, 0.0f, 246.0f, 102, 5, 512, 256);
            int k = VillagerData.m_35572_((int)merchantLevel);
            if (merchantXp >= k && VillagerData.m_35582_((int)merchantLevel)) {
                int l = 100;
                float f = 100.0f / (float)(VillagerData.m_35577_((int)merchantLevel) - k);
                int i1 = Math.min(Mth.m_14143_((float)(f * (float)(merchantXp - k))), l);
                guiGraphics.m_280163_(PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, xPos, yPos, 0.0f, 251.0f, i1 + 1, 5, 512, 256);
            }
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        int merchantLevel = ((PaintingMerchantMenu)this.f_97732_).getMerchantLevel();
        if (merchantLevel > 0 && merchantLevel <= 5) {
            MutableComponent levelText = this.f_96539_.m_6881_().m_7220_(LEVEL_SEPARATOR).m_7220_((Component)Component.m_237115_((String)("merchant.level." + merchantLevel)));
            guiGraphics.m_280614_(this.getFont(), (Component)levelText, 6, 6, Color.darkGray.getRGB(), false);
        } else {
            guiGraphics.m_280614_(this.getFont(), this.f_96539_, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, Color.darkGray.getRGB(), false);
        }
        this.renderOffersCount(guiGraphics, x, y);
    }

    private void renderOffersCount(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!((PaintingMerchantMenu)this.f_97732_).hasOffers()) {
            return;
        }
        PaintingMerchantOffer offer = this.getCurrentOffer();
        if (offer instanceof PaintingMerchantSaleOffer) {
            guiGraphics.m_280653_(this.getFont(), (Component)Component.m_237115_((String)"container.zettergallery.merchant.sell"), 44, 97, Color.white.getRGB());
        } else {
            int currentOffer = this.getCurrentOfferIndex() + 1;
            int offersCount = this.getOffersCount();
            guiGraphics.m_280137_(this.getFont(), currentOffer + "/" + offersCount, 44, 97, Color.white.getRGB());
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE);
        guiGraphics.m_280163_(PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        int SELL_SLOT_X = 119;
        int SELL_SLOT_Y = 119;
        int SELL_SLOT_U = 208;
        int SELL_SLOT_V = 160;
        int SELL_SLOT_WIDTH = 16;
        int SELL_SLOT_HEIGHT = 16;
        int sellSlotVOffset = 0;
        if (this.saleAllowed() && this.tick % 40 > 19) {
            sellSlotVOffset = 16;
        }
        guiGraphics.m_280218_(PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.f_97735_ + 119, this.f_97736_ + 119, 208, 160 + sellSlotVOffset, 16, 16);
        this.authWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.previewWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.paginatorWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.infoWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.refreshWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public void openAuthenticationLink() {
        try {
            AuthorizationCode authorizationCode = ((PaintingMerchantMenu)this.f_97732_).getAuthController().getAuthorizationCode();
            if (authorizationCode == null) {
                throw new IllegalStateException("Unable to start client authentication without cross-auth authorizationCode");
            }
            URI uri = ZetterGallery.DEBUG_LOCALHOST ? new URI("http://localhost:8080/auth/consent") : new URI("https://zetter.gallery/auth/consent");
            uri = PaintingMerchantScreen.addUriParam(uri, "code", ((PaintingMerchantMenu)this.f_97732_).getAuthController().getAuthorizationCode().code);
            ClientHelper.openUriPrompt((Screen)this, uri.toString());
            this.waitingForBrowser = true;
        }
        catch (Exception exception) {
            ZetterGallery.LOG.error(exception.getMessage());
        }
    }

    public static URI addUriParam(URI uri, String name, String value) throws URISyntaxException {
        String appendQuery = name + "=" + value;
        URI oldUri = new URI(uri.toString());
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), oldUri.getQuery() == null ? appendQuery : oldUri.getQuery() + "&" + appendQuery, oldUri.getFragment());
    }

    public boolean saleAllowed() {
        return false;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void prevOffer() {
        if (!((PaintingMerchantMenu)this.f_97732_).hasOffers()) {
            return;
        }
        int newOffersIndex = this.getCurrentOfferIndex() - 1;
        if (newOffersIndex < 0) {
            newOffersIndex = this.getOffersCount() - 1;
        }
        this.updateCurrentOfferIndex(newOffersIndex);
    }

    public void nextOffer() {
        if (!((PaintingMerchantMenu)this.f_97732_).hasOffers()) {
            return;
        }
        int newOffersIndex = this.getCurrentOfferIndex() + 1;
        if (newOffersIndex > ((PaintingMerchantMenu)this.f_97732_).getOffersCount() - 1) {
            newOffersIndex = 0;
        }
        this.updateCurrentOfferIndex(newOffersIndex);
    }

    private void updateCurrentOfferIndex(int newOffersIndex) {
        ((PaintingMerchantMenu)this.f_97732_).updateCurrentOfferIndex(newOffersIndex);
    }

    public void requestNewOffers() {
        CFeedRefreshRequest feedRefreshRequest = new CFeedRefreshRequest();
        ZetterGalleryNetwork.simpleChannel.sendToServer((Object)feedRefreshRequest);
    }

    public int getOffersCount() {
        return ((PaintingMerchantMenu)this.f_97732_).getOffersCount();
    }

    public int getCurrentOfferIndex() {
        if (((PaintingMerchantMenu)this.f_97732_).hasOffers()) {
            return ((PaintingMerchantMenu)this.f_97732_).getCurrentOfferIndex();
        }
        return 0;
    }

    @Nullable
    public PaintingMerchantOffer getCurrentOffer() {
        return ((PaintingMerchantMenu)this.f_97732_).getCurrentOffer();
    }

    public PaintingMerchantContainer.OffersState getOffersState() {
        return ((PaintingMerchantMenu)this.f_97732_).getContainer().getState();
    }

    public MerchantAuthorizationController.PlayerAuthorizationState getPlayerAuthorizationState() {
        return ((PaintingMerchantMenu)this.f_97732_).getAuthController().getState();
    }

    public String getAuthorizedPlayerNickname() {
        PlayerToken.PlayerInfo playerInfo = ((PaintingMerchantMenu)this.f_97732_).getAuthController().getPlayerInfo();
        if (playerInfo != null) {
            return playerInfo.nickname();
        }
        return "Anonymous";
    }
}

