/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.client.gui.merchant;

import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zettergallery.client.gui.PaintingMerchantScreen;
import me.dantaeusb.zettergallery.client.gui.merchant.AbstractPaintingMerchantWidget;
import me.dantaeusb.zettergallery.core.ClientHelper;
import me.dantaeusb.zettergallery.menu.PaintingMerchantMenu;
import me.dantaeusb.zettergallery.menu.paintingmerchant.MerchantAuthorizationController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class AuthWidget
extends AbstractPaintingMerchantWidget {
    @Nullable
    protected Minecraft minecraft;
    protected ItemRenderer itemRenderer;
    protected Font font;
    static final int WIDTH = 98;
    static final int HEIGHT = 26;
    private static final int AUTH_UPOS = 208;
    private static final int AUTH_VPOS = 50;
    private int tick = 0;
    private static final Component AUTHENTICATING_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.authenticating");
    private static final Component LOGIN_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.login_request");
    private static final Component UNKNOWN_ERROR_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.unknown_error");
    private static final Component TRY_AGAIN_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.try_again");
    private static final Component DISABLED_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.login_disabled");
    private static final Component LINKS_DISABLED_TOOLTIP_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.links_disabled_tooltip");
    private static final Component LOGIN_TOOLTIP_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.login_request_tooltip");
    private static final Component WAITING_TOOLTIP_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.login_waiting");
    private static final int LOADING_WIDTH = 16;
    private static final int LOADING_HEIGHT = 10;
    private static final int LOADING_XPOS = 8;
    private static final int LOADING_YPOS = 8;
    private static final int LOADING_UPOS = 208;
    private static final int LOADING_VPOS = 20;

    public AuthWidget(PaintingMerchantScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 98, 26, (Component)Component.m_237115_((String)"container.zetter.painting.status"));
        this.minecraft = parentScreen.getMinecraft();
        this.itemRenderer = this.minecraft.m_91291_();
        this.font = this.minecraft.f_91062_;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        block0 : switch (this.parentScreen.getPlayerAuthorizationState()) {
            case SERVER_AUTHENTICATION: {
                guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 208.0f, 102.0f, 98, 26, 512, 256);
                this.renderLoading(guiGraphics);
                guiGraphics.m_280430_(this.parentScreen.getFont(), AUTHENTICATING_TEXT, this.m_252754_() + 32, this.m_252907_() + 8, Color.white.getRGB());
                break;
            }
            case CLIENT_AUTHORIZATION: {
                if (!ClientHelper.openUriAllowed()) {
                    guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 208.0f, 50.0f, 98, 26, 512, 256);
                    guiGraphics.m_280653_(this.font, DISABLED_TEXT, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + 10, Color.white.getRGB());
                    break;
                }
                if (!this.isPointInRegion(0, 0, 98, 26, mouseX, mouseY)) {
                    guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 208.0f, 50.0f, 98, 26, 512, 256);
                } else {
                    guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 208.0f, 76.0f, 98, 26, 512, 256);
                }
                guiGraphics.m_280653_(this.font, LOGIN_TEXT, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + 10, Color.white.getRGB());
                break;
            }
            case LOGGED_IN: {
                guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 208.0f, 102.0f, 98, 26, 512, 256);
                guiGraphics.m_280137_(this.font, this.parentScreen.getAuthorizedPlayerNickname(), this.m_252754_() + 26, this.m_252907_() + 9, Color.white.getRGB());
                break;
            }
            case ERROR: {
                guiGraphics.m_280398_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_(), this.m_252754_(), this.m_252907_(), 208.0f, 102.0f, 98, 26, 512, 256);
                Component errorMessage = ((PaintingMerchantMenu)this.parentScreen.m_6262_()).getAuthController().hasError() ? Component.m_130674_((String)((PaintingMerchantMenu)this.parentScreen.m_6262_()).getAuthController().getError().getMessage()) : UNKNOWN_ERROR_TEXT;
                List lines = this.font.m_92923_((FormattedText)errorMessage, 92);
                int i = 0;
                int yPos = 4;
                if (lines.size() == 1) {
                    yPos += 6;
                }
                for (FormattedCharSequence line : lines) {
                    guiGraphics.m_280364_(this.font, line, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + yPos + i++ * 10, Color.white.getRGB());
                    if (i != 2) continue;
                    break block0;
                }
                break;
            }
        }
    }

    public void tick() {
        ++this.tick;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!ClientHelper.openUriAllowed()) {
            return false;
        }
        if (this.parentScreen.getPlayerAuthorizationState() == MerchantAuthorizationController.PlayerAuthorizationState.CLIENT_AUTHORIZATION && this.isPointInRegion(0, 0, 98, 26, mouseX, mouseY)) {
            this.m_7435_(this.minecraft.m_91106_());
            this.parentScreen.openAuthenticationLink();
        }
        return false;
    }

    private void renderLoading(GuiGraphics guiGraphics) {
        int animation = this.tick % 40;
        int frame = animation / 10;
        frame = frame > 2 ? 1 : frame;
        guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + 8, this.m_252907_() + 8, 208.0f, (float)(20 + 10 * frame), 16, 10, 512, 256);
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        switch (this.parentScreen.getPlayerAuthorizationState()) {
            case SERVER_AUTHENTICATION: {
                return WAITING_TOOLTIP_TEXT;
            }
            case CLIENT_AUTHORIZATION: {
                if (!ClientHelper.openUriAllowed()) {
                    return LINKS_DISABLED_TOOLTIP_TEXT;
                }
                return LOGIN_TOOLTIP_TEXT;
            }
            case LOGGED_IN: {
                return Component.m_237110_((String)"container.zettergallery.merchant.logged_in_player_tooltip", (Object[])new Object[]{this.parentScreen.getAuthorizedPlayerNickname()});
            }
            case ERROR: {
                return null;
            }
        }
        return super.getTooltip(mouseX, mouseY);
    }

    protected boolean isPointInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        int i = this.m_252754_();
        int j = this.m_252907_();
        return (mouseX -= (double)i) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)j) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }
}

