/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.client.gui.merchant;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.client.gui.PaintingMerchantScreen;
import me.dantaeusb.zettergallery.client.gui.merchant.AbstractPaintingMerchantWidget;
import me.dantaeusb.zettergallery.container.PaintingMerchantContainer;
import me.dantaeusb.zettergallery.menu.PaintingMerchantMenu;
import me.dantaeusb.zettergallery.trading.PaintingMerchantOffer;
import me.dantaeusb.zettergallery.trading.PaintingMerchantPurchaseOffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class OfferInfoWidget
extends AbstractPaintingMerchantWidget {
    private static final Component FETCHING_OFFERS = Component.m_237115_((String)"container.zettergallery.merchant.fetching_offers");
    private static final Component LOADING_PAINTING = Component.m_237115_((String)"container.zettergallery.merchant.loading_painting");
    private static final Component UNKNOWN_OFFER_ERROR = Component.m_237115_((String)"container.zettergallery.merchant.offer.unknown_error");
    @Nullable
    protected Minecraft minecraft;
    protected ItemRenderer itemRenderer;
    protected Font font;
    private int tick = 0;
    private static final int WIDTH = 196;
    private static final int HEIGHT = 74;
    private static final int LOGO_WIDTH = 32;
    private static final int LOGO_HEIGHT = 32;
    private static final int LOGO_UPOS = 208;
    private static final int LOGO_VPOS = 128;
    private static final int LOGO_XPOS = 82;
    private static final int LOGO_YPOS = 13;
    private static final int LOGO_LOADER_WIDTH = 16;
    private static final int LOGO_LOADER_HEIGHT = 20;
    private static final int LOGO_LOADER_UPOS = 240;
    private static final int LOGO_LOADER_VPOS = 128;
    private static final int LOGO_LOADER_XPOS = 90;
    private static final int LOGO_LOADER_YPOS = 19;

    public OfferInfoWidget(PaintingMerchantScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 196, 74, (Component)Component.m_237115_((String)"container.zetter.painting.info"));
        this.minecraft = parentScreen.getMinecraft();
        this.itemRenderer = this.minecraft.m_91291_();
        this.font = this.minecraft.f_91062_;
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parentScreen.getOffersState().equals((Object)PaintingMerchantContainer.OffersState.LOADING)) {
            this.renderLoadingLogo(guiGraphics);
        } else if (this.parentScreen.getOffersState().equals((Object)PaintingMerchantContainer.OffersState.ERROR)) {
            this.renderErrorMessage(guiGraphics, ((PaintingMerchantMenu)this.parentScreen.m_6262_()).getAuthController().getError().getMessage());
        } else {
            this.renderPaintingInfo(guiGraphics);
        }
    }

    private void renderLoadingLogo(GuiGraphics guiGraphics) {
        int animation = this.tick % 200;
        int frame = animation / 10;
        guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + 90, this.m_252907_() + 19, 240.0f, (float)(128 + frame), 16, 20, 512, 256);
        guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + 82, this.m_252907_() + 13, 208.0f, 128.0f, 32, 32, 512, 256);
        guiGraphics.m_280653_(this.parentScreen.getFont(), FETCHING_OFFERS, this.m_252754_() + 82 + 16, this.m_252907_() + 13 + 32 + 7, Color.white.getRGB());
    }

    private void renderPaintingInfo(GuiGraphics guiGraphics) {
        PaintingMerchantPurchaseOffer purchaseOffer;
        PaintingMerchantOffer offer = this.parentScreen.getCurrentOffer();
        if (offer == null) {
            ZetterGallery.LOG.error("No offer to render info");
            return;
        }
        if (this.isLoading()) {
            guiGraphics.m_280653_(this.parentScreen.getFont(), LOADING_PAINTING, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + this.f_93619_ / 2 - 4, Color.white.getRGB());
            return;
        }
        if (offer.isError()) {
            String errorMessage = offer.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = UNKNOWN_OFFER_ERROR.getString();
            }
            this.renderErrorMessage(guiGraphics, errorMessage);
            return;
        }
        DummyCanvasData offerPaintingData = offer.getDummyPaintingData();
        String priceString = String.valueOf(offer.getPrice());
        int priceWidth = this.font.m_92895_(priceString);
        ItemStack emeraldStack = new ItemStack((ItemLike)Items.f_42616_);
        guiGraphics.m_280203_(emeraldStack, this.m_252754_() + this.f_93618_ - 23, this.m_252907_() + 63);
        guiGraphics.m_280056_(this.parentScreen.getFont(), priceString, this.m_252754_() + this.f_93618_ - 24 - priceWidth, this.m_252907_() + 67, Color.white.getRGB(), false);
        int widthBlocks = offerPaintingData.getWidth() / offerPaintingData.getResolution().getNumeric();
        int heightBlocks = offerPaintingData.getHeight() / offerPaintingData.getResolution().getNumeric();
        MutableComponent blockSize = Component.m_237110_((String)"item.zetter.painting.size", (Object[])new Object[]{Integer.toString(widthBlocks), Integer.toString(heightBlocks)});
        List multilinePaintingTitle = this.font.m_92923_(FormattedText.m_130775_((String)offer.getPaintingName()), 80);
        List multilineNickname = this.font.m_92923_(FormattedText.m_130775_((String)offer.getAuthorName()), 80);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE);
        if (offer instanceof PaintingMerchantPurchaseOffer && (purchaseOffer = (PaintingMerchantPurchaseOffer)offer).getFeedName() != null) {
            int feedIconU = 16;
            switch (purchaseOffer.getFeedName()) {
                case "new": {
                    feedIconU = 16;
                    break;
                }
                case "top": {
                    feedIconU = 32;
                    break;
                }
                case "favorite": {
                    feedIconU = 48;
                    break;
                }
            }
            guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + 196 - 16 - 5, this.m_252907_() + 5, (float)(304 + feedIconU), 0.0f, 16, 16, 512, 256);
        }
        int ICON_OFFSET = 74;
        int TEXT_OFFSET = 87;
        guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + 74, this.m_252907_() + 4, 265.0f, 0.0f, 8, 8, 512, 256);
        guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + 74, this.m_252907_() + 4 + 11 * multilinePaintingTitle.size(), 265.0f, 8.0f, 8, 8, 512, 256);
        guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + 74, this.m_252907_() + 4 + 11 * multilinePaintingTitle.size() + 11 * multilineNickname.size(), (float)(273 + (widthBlocks - 1) * 8), (float)((heightBlocks - 1) * 8), 8, 8, 512, 256);
        int titleNameLines = 0;
        for (FormattedCharSequence paintingTitleNameLine : multilinePaintingTitle) {
            guiGraphics.m_280649_(this.parentScreen.getFont(), paintingTitleNameLine, this.m_252754_() + 87, this.m_252907_() + 5 + 11 * titleNameLines++, Color.white.getRGB(), false);
        }
        int nicknameLines = 0;
        for (FormattedCharSequence nicknameLine : multilineNickname) {
            guiGraphics.m_280649_(this.parentScreen.getFont(), nicknameLine, this.m_252754_() + 87, this.m_252907_() + 5 + 11 * titleNameLines + 11 * nicknameLines++, Color.white.getRGB(), false);
        }
        guiGraphics.m_280056_(this.parentScreen.getFont(), blockSize.getString(), this.m_252754_() + 87, this.m_252907_() + 5 + 11 * titleNameLines + 11 * nicknameLines, Color.white.getRGB(), false);
    }

    private void renderErrorMessage(GuiGraphics guiGraphics, String errorMessage) {
        List multilineErrorMessage = this.font.m_92923_(FormattedText.m_130775_((String)errorMessage), 186);
        int errorLines = 0;
        for (FormattedCharSequence errorLine : multilineErrorMessage) {
            guiGraphics.m_280364_(this.parentScreen.getFont(), errorLine, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + 20 + 11 * errorLines++, Color.white.getRGB());
        }
    }

    public boolean isLoading() {
        if (this.parentScreen.getCurrentOffer() == null) {
            return false;
        }
        return this.parentScreen.getCurrentOffer().isLoading();
    }

    public boolean canProceed() {
        if (this.parentScreen.getCurrentOffer() == null) {
            return false;
        }
        return this.parentScreen.getCurrentOffer().isReady();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public void tick() {
        ++this.tick;
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    protected boolean isPointInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        int i = this.m_252754_();
        int j = this.m_252907_();
        return (mouseX -= (double)i) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)j) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }
}

