/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.client.gui.merchant;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zettergallery.client.gui.PaintingMerchantScreen;
import me.dantaeusb.zettergallery.client.gui.merchant.AbstractPaintingMerchantWidget;
import me.dantaeusb.zettergallery.trading.PaintingMerchantOffer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PaintingPreviewWidget
extends AbstractPaintingMerchantWidget {
    private static final Component LOADING_TEXT = Component.m_237115_((String)"container.zettergallery.merchant.preview.loading");
    static final int WIDTH = 64;
    static final int HEIGHT = 64;
    private int tick = 0;
    private static final int LOADING_WIDTH = 16;
    private static final int LOADING_HEIGHT = 10;
    private static final int LOADING_UPOS = 208;
    private static final int LOADING_VPOS = 20;

    public PaintingPreviewWidget(PaintingMerchantScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 64, 64, (Component)Component.m_237115_((String)"container.zettergallery.merchant.preview"));
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PaintingMerchantOffer offer = this.parentScreen.getCurrentOffer();
        if (offer == null || offer.isError()) {
            return;
        }
        if (this.isLoading()) {
            this.renderLoading(guiGraphics);
            return;
        }
        String canvasCode = offer.getDummyCanvasCode();
        DummyCanvasData offerPaintingData = offer.getDummyPaintingData();
        float maxSize = (float)Math.max(offerPaintingData.getHeight(), offerPaintingData.getWidth()) / 16.0f;
        float scale = 4.0f / maxSize;
        float scaledWidth = (float)offerPaintingData.getWidth() * scale;
        float scaledHeight = (float)offerPaintingData.getHeight() * scale;
        float aspectRatio = scaledWidth / scaledHeight;
        int offsetX = 0;
        int offsetY = 0;
        if (aspectRatio > 1.0f) {
            offsetY += Math.round((64.0f - scaledHeight) / 2.0f);
        } else if (aspectRatio < 1.0f) {
            offsetX += Math.round((64.0f - scaledWidth) / 2.0f);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(this.m_252754_() + offsetX), (float)(this.m_252907_() + offsetY), 1.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        MultiBufferSource.BufferSource renderBuffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        CanvasRenderer.getInstance().renderCanvas(poseStack, (MultiBufferSource)renderBuffers, canvasCode, (AbstractCanvasData)offerPaintingData, 0xF000F0);
        renderBuffers.m_109911_();
        poseStack.m_85849_();
    }

    private void renderLoading(GuiGraphics guiGraphics) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE);
        int animation = this.tick % 40;
        int frame = animation / 10;
        frame = frame > 2 ? 1 : frame;
        guiGraphics.m_280163_(PaintingMerchantScreen.PAINTING_MERCHANT_GUI_TEXTURE_RESOURCE, this.m_252754_() + (this.f_93618_ - 16) / 2, this.m_252907_() + (this.f_93619_ - 10) / 2, 208.0f, (float)(20 + 10 * frame), 16, 10, 512, 256);
    }

    public boolean isLoading() {
        if (this.parentScreen.getCurrentOffer() == null) {
            return false;
        }
        return this.parentScreen.getCurrentOffer().isLoading();
    }

    public void tick() {
        ++this.tick;
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        PaintingMerchantOffer offer = this.parentScreen.getCurrentOffer();
        if (offer == null) {
            return null;
        }
        if (offer.isLoading()) {
            return LOADING_TEXT;
        }
        return null;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }
}

