/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.security.InvalidParameterException;
import me.dantaeusb.zetter.client.gui.overlay.PaintingInfoOverlay;
import me.dantaeusb.zetter.storage.PaintingData;
import me.dantaeusb.zettergallery.storage.GalleryPaintingData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class GalleryPaintingInfoOverlay
extends PaintingInfoOverlay
implements IGuiOverlay {
    protected GalleryPaintingData paintingData;

    public void setCanvasData(PaintingData galleryPaintingData) {
        if (!(galleryPaintingData instanceof GalleryPaintingData)) {
            throw new InvalidParameterException("This overlay should be used exclusively for Gallery Paintings");
        }
        this.paintingData = (GalleryPaintingData)galleryPaintingData;
        this.overlayMessageTime = 300;
    }

    public void hide() {
        this.paintingData = null;
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (this.paintingData == null) {
            return;
        }
        if (this.overlayMessageTime <= 0) {
            this.paintingData = null;
            return;
        }
        String paintingName = this.paintingData.getPaintingName();
        String authorName = this.paintingData.getAuthorName();
        if (StringUtil.m_14408_((String)paintingName)) {
            paintingName = Component.m_237115_((String)"item.zetter.painting.unnamed").getString();
        }
        if (StringUtil.m_14408_((String)authorName)) {
            authorName = Component.m_237115_((String)"item.zetter.painting.unknown").getString();
        }
        MutableComponent title = Component.m_237110_((String)"item.zetter.customPaintingByAuthor", (Object[])new Object[]{paintingName, authorName});
        float ticksLeft = (float)this.overlayMessageTime - partialTick;
        int msLeft = (int)(ticksLeft * 255.0f / 20.0f);
        if (msLeft > 255) {
            msLeft = 255;
        }
        if (msLeft > 8) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)(screenWidth / 2), (double)(screenHeight - 68), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int textColor = 0xFFFFFF;
            int transparencyMask = msLeft << 24 & 0xFF000000;
            int titleLength = gui.m_93082_().m_92852_((FormattedText)title);
            this.drawBackdrop(guiGraphics, -4, titleLength, 0xFFFFFF | transparencyMask);
            guiGraphics.m_280430_(gui.m_93082_(), (Component)title, -titleLength / 2, -4, textColor | transparencyMask);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }
}

