/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.container;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.core.ZetterGalleryNetwork;
import me.dantaeusb.zettergallery.gallery.ConnectionManager;
import me.dantaeusb.zettergallery.gallery.SalesManager;
import me.dantaeusb.zettergallery.menu.PaintingMerchantMenu;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.network.http.dto.PaintingsResponse;
import me.dantaeusb.zettergallery.network.packet.CSelectOfferPacket;
import me.dantaeusb.zettergallery.network.packet.SOfferStatePacket;
import me.dantaeusb.zettergallery.network.packet.SOffersPacket;
import me.dantaeusb.zettergallery.trading.PaintingMerchantOffer;
import me.dantaeusb.zettergallery.trading.PaintingMerchantPurchaseOffer;
import me.dantaeusb.zettergallery.trading.PaintingMerchantSaleOffer;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class PaintingMerchantContainer
implements Container {
    public static final int STORAGE_SIZE = 2;
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private final NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final Player player;
    private final Merchant merchant;
    private final PaintingMerchantMenu menu;
    @Nullable
    private List<ContainerListener> listeners;
    private PaintingMerchantOffer currentOffer;
    private OffersState state = OffersState.LOADING;
    private GalleryError error;
    private boolean locked = false;
    private int selectedPurchaseOfferIndex;
    private static final int FORCE_FEED_UPDATE_TIMEOUT = 75000;
    private PaintingsResponse.CycleInfo currentCycle;
    @Nullable
    private List<PaintingMerchantPurchaseOffer> purchaseOffers;

    public PaintingMerchantContainer(Player player, Merchant merchant, PaintingMerchantMenu menu) {
        this.player = player;
        this.merchant = merchant;
        this.menu = menu;
    }

    public PaintingMerchantMenu getMenu() {
        return this.menu;
    }

    public OffersState getState() {
        return this.state;
    }

    public boolean hasError() {
        return this.state == OffersState.ERROR;
    }

    @Nullable
    public GalleryError getError() {
        if (this.hasError()) {
            if (this.error == null) {
                this.error = new GalleryError(0, "Something went wrong");
            }
            return this.error;
        }
        return null;
    }

    @Nullable
    public PaintingsResponse.CycleInfo getCurrentCycle() {
        return this.currentCycle;
    }

    public int getSecondsToNextCycle() {
        if (this.currentCycle == null) {
            return 0;
        }
        return (int)(this.currentCycle.endsAt.getTime() - new Date().getTime()) / 1000;
    }

    public int getSecondsToForceUpdateCycle() {
        if (this.currentCycle == null) {
            return 0;
        }
        return (int)(this.currentCycle.endsAt.getTime() + 75000L - new Date().getTime()) / 1000;
    }

    public boolean canUpdate() {
        if (this.currentCycle == null) {
            return false;
        }
        return this.getSecondsToNextCycle() < 0;
    }

    public boolean needUpdate() {
        if (this.currentCycle == null) {
            return false;
        }
        return this.getSecondsToForceUpdateCycle() < 0;
    }

    public void m_6596_() {
        ItemStack inputStack = this.getInputSlot();
        Object selectedPurchaseOffer = null;
        if (this.purchaseOffers != null && this.purchaseOffers.size() > this.selectedPurchaseOfferIndex) {
            selectedPurchaseOffer = this.purchaseOffers.get(this.selectedPurchaseOfferIndex);
        }
        if (this.hasOffers()) {
            if (inputStack.m_41619_()) {
                if (selectedPurchaseOffer != null && !selectedPurchaseOffer.equals(this.currentOffer)) {
                    this.currentOffer = selectedPurchaseOffer;
                }
                if (this.currentOffer != null) {
                    this.currentOffer.unfulfilled();
                }
                this.m_6836_(1, ItemStack.f_41583_);
            } else if (inputStack.m_41720_() == ZetterItems.PAINTING.get()) {
                PaintingMerchantSaleOffer saleOffer;
                String canvasCode = PaintingItem.getPaintingCode((ItemStack)inputStack);
                int generation = PaintingItem.getGeneration((ItemStack)inputStack);
                if (this.currentOffer != null && this.currentOffer instanceof PaintingMerchantSaleOffer && this.currentOffer.getRealCanvasCode().equals(canvasCode)) {
                    if (this.currentOffer.isReady()) {
                        this.m_6836_(1, this.currentOffer.getOfferResult());
                    }
                    return;
                }
                PaintingData paintingData = (PaintingData)Helper.getLevelCanvasTracker((Level)this.merchant.m_7962_().m_9236_()).getCanvasData(canvasCode);
                if (paintingData != null) {
                    saleOffer = PaintingMerchantSaleOffer.createOfferFromPlayersPainting(canvasCode, paintingData, generation, 4);
                    Level level = this.merchant.m_7962_().m_9236_();
                    if (level.m_5776_()) {
                        saleOffer.register(this.merchant.m_7962_().m_9236_());
                    }
                } else {
                    saleOffer = PaintingMerchantSaleOffer.createOfferWithoutPlayersPainting(canvasCode, this.merchant.m_7962_(), generation, 4);
                    CanvasRenderer.getInstance().queueCanvasTextureUpdate(canvasCode);
                }
                this.currentOffer = saleOffer;
                if (saleOffer.validate(this.merchant) && !this.merchant.m_183595_()) {
                    ConnectionManager.getInstance().validateSale((ServerPlayer)this.merchant.m_7962_(), saleOffer, () -> {
                        saleOffer.ready();
                        SOfferStatePacket offerStatePacket = new SOfferStatePacket(saleOffer.getDummyCanvasCode(), PaintingMerchantOffer.State.READY, "Ready");
                        ZetterGalleryNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.merchant.m_7962_()), (Object)offerStatePacket);
                    }, error -> {
                        saleOffer.markError((GalleryError)error);
                        SOfferStatePacket offerStatePacket = new SOfferStatePacket(saleOffer.getDummyCanvasCode(), PaintingMerchantOffer.State.ERROR, error.getClientMessage());
                        ZetterGalleryNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.merchant.m_7962_()), (Object)offerStatePacket);
                    });
                }
            } else if (inputStack.m_41720_() == Items.f_42616_) {
                if (selectedPurchaseOffer != null && !selectedPurchaseOffer.equals(this.currentOffer)) {
                    this.currentOffer = selectedPurchaseOffer;
                }
                if (this.currentOffer != null) {
                    if (this.currentOffer.getPrice() <= inputStack.m_41613_()) {
                        this.currentOffer.ready();
                        this.m_6836_(1, this.currentOffer.getOfferResult());
                    } else {
                        this.currentOffer.unfulfilled();
                        this.m_6836_(1, ItemStack.f_41583_);
                    }
                }
            }
            if (this.listeners != null) {
                for (ContainerListener containerlistener : this.listeners) {
                    containerlistener.m_5757_((Container)this);
                }
            }
        }
    }

    public void requestFeed() {
        SalesManager.getInstance().registerTrackingPlayer((ServerPlayer)this.player);
        SalesManager.getInstance().acquireMerchantOffers((ServerPlayer)this.player, this, this::handleFeed, this::handleError);
    }

    public void handleFeed(PaintingsResponse.CycleInfo cycleInfo, List<PaintingMerchantPurchaseOffer> offers) {
        if (this.state == OffersState.LOADING) {
            this.state = this.state.success();
        }
        this.currentCycle = cycleInfo;
        this.purchaseOffers = offers;
        this.selectedPurchaseOfferIndex = 0;
        this.updateCurrentOffer();
        this.registerOffersCanvases();
        if (!this.player.m_7578_()) {
            SOffersPacket salesPacket = new SOffersPacket(cycleInfo, this.getPurchaseOffers());
            ZetterGalleryNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)salesPacket);
        }
    }

    public void registerOffersCanvases() {
        if (this.merchant.m_183595_() && this.getPurchaseOffers() != null) {
            CanvasTracker tracker = Helper.getLevelCanvasTracker((Level)this.merchant.m_7962_().m_9236_());
            for (PaintingMerchantPurchaseOffer offer : this.getPurchaseOffers()) {
                DummyCanvasData paintingData = offer.getDummyPaintingData();
                tracker.registerCanvasData(offer.getDummyCanvasCode(), (AbstractCanvasData)paintingData);
            }
        }
    }

    public void unregisterOffersCanvases() {
        if (this.merchant.m_183595_()) {
            Level level = this.merchant.m_7962_().m_9236_();
            if (this.getPurchaseOffers() != null) {
                CanvasTracker tracker = Helper.getLevelCanvasTracker((Level)level);
                for (PaintingMerchantPurchaseOffer offer : this.getPurchaseOffers()) {
                    tracker.unregisterCanvasData(offer.getDummyCanvasCode());
                }
            }
            PaintingMerchantSaleOffer.unregister(level);
        }
    }

    public void checkout(ItemStack purchaseStack) {
        ItemStack stack;
        PaintingMerchantOffer paintingOffer = this.getCurrentOffer();
        MerchantOffer merchantOffer = this.getVanillaMerchantOffer(paintingOffer);
        if (!merchantOffer.m_45361_(stack = (ItemStack)this.itemStacks.get(0), ItemStack.f_41583_)) {
            Zetter.LOG.error("Cannot take offer");
            return;
        }
        if (!paintingOffer.isReady()) {
            Zetter.LOG.error("Offer is not ready for checkout");
            return;
        }
        this.merchant.m_6996_(merchantOffer);
        this.merchant.m_7962_().m_36220_(Stats.f_12941_);
        this.merchant.m_6621_(this.merchant.m_7809_() + merchantOffer.m_45379_());
        if (paintingOffer instanceof PaintingMerchantSaleOffer) {
            PaintingMerchantSaleOffer saleOffer = (PaintingMerchantSaleOffer)paintingOffer;
            this.itemStacks.set(0, (Object)ItemStack.f_41583_);
            if (!this.merchant.m_7962_().m_7578_()) {
                ConnectionManager.getInstance().registerSale((ServerPlayer)this.player, saleOffer, this::finalizeCheckout, paintingOffer::markError);
            }
        } else if (paintingOffer instanceof PaintingMerchantPurchaseOffer) {
            PaintingMerchantPurchaseOffer purchaseOffer = (PaintingMerchantPurchaseOffer)paintingOffer;
            purchaseOffer.writeOfferResultData(this.merchant.m_7962_().m_9236_(), purchaseStack);
            if (!this.merchant.m_7962_().m_9236_().m_5776_()) {
                ConnectionManager.getInstance().registerPurchase((ServerPlayer)this.player, purchaseOffer.getPaintingUuid(), purchaseOffer.getPrice(), purchaseOffer.getCycleIncrementId(), this::finalizeCheckout, paintingOffer::markError);
            }
        }
        this.updateCurrentOffer();
    }

    public void finalizeCheckout() {
        this.playTradeSound();
    }

    public void handleError(GalleryError error) {
        this.error = error;
        this.state = this.state.error();
    }

    public void removed() {
        if (this.merchant.m_7962_().m_7578_()) {
            this.unregisterOffersCanvases();
        } else {
            SalesManager.getInstance().unregisterTrackingPlayer((ServerPlayer)this.player);
        }
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    @Nullable
    public List<PaintingMerchantPurchaseOffer> getPurchaseOffers() {
        return this.purchaseOffers;
    }

    public boolean hasOffers() {
        return this.purchaseOffers != null && this.purchaseOffers.size() > 0;
    }

    public int getOffersCount() {
        if (this.hasOffers()) {
            return this.getPurchaseOffers().size();
        }
        return 0;
    }

    public void updateSaleOfferPaintingData(String canvasCode, PaintingData paintingData) {
        PaintingMerchantOffer paintingMerchantOffer;
        if (!this.merchant.m_7962_().m_9236_().m_5776_()) {
            throw new IllegalStateException("Should not update offer painting data on server");
        }
        if (this.getCurrentOffer() == null || !this.getCurrentOffer().getRealCanvasCode().equals(canvasCode) || !((paintingMerchantOffer = this.currentOffer) instanceof PaintingMerchantSaleOffer)) {
            return;
        }
        PaintingMerchantSaleOffer saleOffer = (PaintingMerchantSaleOffer)paintingMerchantOffer;
        DummyCanvasData paintingWrap = (DummyCanvasData)((CanvasDataType)ZetterCanvasTypes.DUMMY.get()).createWrap(paintingData.getResolution(), paintingData.getWidth(), paintingData.getHeight(), paintingData.getColorData());
        saleOffer.updatePaintingData(paintingData.getPaintingName(), paintingWrap, paintingData.getAuthorUuid(), paintingData.getAuthorName());
        saleOffer.register(this.merchant.m_7962_().m_9236_());
    }

    private void playTradeSound() {
        if (!this.merchant.m_183595_()) {
            Entity entity = (Entity)this.merchant;
            entity.m_9236_().m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.merchant.m_7596_(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    @Nullable
    public PaintingMerchantOffer getCurrentOffer() {
        return this.currentOffer;
    }

    @Nullable
    public PaintingMerchantPurchaseOffer getCurrentPurchaseOffer() {
        return this.purchaseOffers.get(this.getSelectedPurchaseOfferIndex());
    }

    public int getSelectedPurchaseOfferIndex() {
        return this.selectedPurchaseOfferIndex;
    }

    public void updateCurrentOffer() {
        this.setSelectedPurchaseOfferIndex(this.getSelectedPurchaseOfferIndex());
    }

    private MerchantOffer getVanillaMerchantOffer(PaintingMerchantOffer offer) {
        if (offer instanceof PaintingMerchantSaleOffer) {
            return (MerchantOffer)this.merchant.m_6616_().get(1);
        }
        return (MerchantOffer)this.merchant.m_6616_().get(0);
    }

    public void setSelectedPurchaseOfferIndex(int index) {
        if (!this.hasOffers()) {
            ZetterGallery.LOG.error("No offers loaded yet");
            return;
        }
        if (index >= this.purchaseOffers.size()) {
            ZetterGallery.LOG.error("There's no offer with such index");
            return;
        }
        this.selectedPurchaseOfferIndex = index;
        this.m_6596_();
        if (this.merchant.m_7962_().m_7578_()) {
            CSelectOfferPacket selectOfferPacket = new CSelectOfferPacket(index);
            ZetterGalleryNetwork.simpleChannel.sendToServer((Object)selectOfferPacket);
        }
    }

    public void addListener(ContainerListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public int m_6643_() {
        return 2;
    }

    public ItemStack getInputSlot() {
        return this.m_8020_(0);
    }

    public ItemStack getOutputSlot() {
        return this.m_8020_(1);
    }

    public boolean m_6542_(Player player) {
        return this.merchant.m_7962_() == player;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return !this.locked;
    }

    public boolean canTakeItem(int index) {
        return !this.locked;
    }

    public void m_5856_(Player player) {
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            if (((ItemStack)this.itemStacks.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void stopOpen() {
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.itemStacks, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.itemStacks, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OffersState {
        LOADING{

            @Override
            public OffersState success() {
                return LOADED;
            }

            @Override
            public OffersState fail() {
                return ERROR;
            }
        }
        ,
        LOADED{

            @Override
            public OffersState success() {
                return LOADED;
            }

            @Override
            public OffersState fail() {
                return ERROR;
            }
        }
        ,
        ERROR{

            @Override
            public OffersState success() {
                return this;
            }

            @Override
            public OffersState fail() {
                return this;
            }
        };


        public abstract OffersState success();

        public abstract OffersState fail();

        private OffersState error() {
            return ERROR;
        }
    }
}

