/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.core;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import me.dantaeusb.zetter.Zetter;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;

public class ClientHelper {
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});

    public static boolean openUriAllowed() {
        return (Boolean)Minecraft.m_91087_().f_91066_.m_231815_().m_231551_();
    }

    public static void openUriPrompt(Screen parentScreen, String href) {
        Minecraft mc = Minecraft.m_91087_();
        if (!me.dantaeusb.zetter.core.ClientHelper.openUriAllowed()) {
            return;
        }
        try {
            URI uri = new URI(href);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(href, "Missing protocol");
            }
            if (!ALLOWED_PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(href, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            if (((Boolean)mc.f_91066_.m_231816_().m_231551_()).booleanValue()) {
                mc.m_91152_((Screen)new ConfirmLinkScreen(result -> {
                    if (result) {
                        ClientHelper.openUri(uri);
                    }
                    mc.m_91152_(parentScreen);
                }, href, true));
            } else {
                ClientHelper.openUri(uri);
            }
        }
        catch (URISyntaxException e) {
            Zetter.LOG.error("Can't open url {}", (Object)href, (Object)e);
        }
    }

    private static void openUri(URI uri) {
        Util.m_137581_().m_137648_(uri);
    }
}

