/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.core;

import java.util.Optional;
import me.dantaeusb.zettergallery.network.packet.CAuthorizationCheckPacket;
import me.dantaeusb.zettergallery.network.packet.CFeedRefreshRequest;
import me.dantaeusb.zettergallery.network.packet.CSelectOfferPacket;
import me.dantaeusb.zettergallery.network.packet.SAbstractErrorPacket;
import me.dantaeusb.zettergallery.network.packet.SAuthErrorPacket;
import me.dantaeusb.zettergallery.network.packet.SAuthenticationPlayerResponsePacket;
import me.dantaeusb.zettergallery.network.packet.SAuthorizationCodeResponsePacket;
import me.dantaeusb.zettergallery.network.packet.SMerchantOffersPacket;
import me.dantaeusb.zettergallery.network.packet.SOfferStatePacket;
import me.dantaeusb.zettergallery.network.packet.SOffersErrorPacket;
import me.dantaeusb.zettergallery.network.packet.SOffersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="zettergallery", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZetterGalleryNetwork {
    public static SimpleChannel simpleChannel;
    public static final ResourceLocation simpleChannelRL;
    public static final String MESSAGE_PROTOCOL_VERSION = "0.1";
    public static final byte GALLERY_AUTHORIZATION_REQUEST = 50;
    public static final byte GALLERY_AUTHORIZATION_CHECK = 51;
    public static final byte GALLERY_UNAUTHORIZED_RESPONSE = 52;
    public static final byte GALLERY_AUTHORIZED_RESPONSE = 53;
    public static final byte GALLERY_OFFERS_RESPONSE = 54;
    public static final byte GALLERY_SELECT_OFFER = 55;
    public static final byte GALLERY_REFRESH_OFFERS = 56;
    public static final byte GALLERY_MERCHANT_INFO = 58;
    public static final byte GALLERY_OFFERS_ERROR = 60;
    public static final byte GALLERY_OFFER_STATE = 61;
    public static final byte GALLERY_AUTH_ERROR = 62;

    @SubscribeEvent
    public static void onCommonSetupEvent(FMLCommonSetupEvent event) {
        simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)simpleChannelRL, () -> MESSAGE_PROTOCOL_VERSION, ZetterGalleryNetwork::isThisProtocolAcceptedByClient, ZetterGalleryNetwork::isThisProtocolAcceptedByServer);
        simpleChannel.registerMessage(51, CAuthorizationCheckPacket.class, CAuthorizationCheckPacket::writePacketData, CAuthorizationCheckPacket::readPacketData, CAuthorizationCheckPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(52, SAuthorizationCodeResponsePacket.class, SAuthorizationCodeResponsePacket::writePacketData, SAuthorizationCodeResponsePacket::readPacketData, SAuthorizationCodeResponsePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(53, SAuthenticationPlayerResponsePacket.class, SAuthenticationPlayerResponsePacket::writePacketData, SAuthenticationPlayerResponsePacket::readPacketData, SAuthenticationPlayerResponsePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(54, SOffersPacket.class, SOffersPacket::writePacketData, SOffersPacket::readPacketData, SOffersPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(55, CSelectOfferPacket.class, CSelectOfferPacket::writePacketData, CSelectOfferPacket::readPacketData, CSelectOfferPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(56, CFeedRefreshRequest.class, CFeedRefreshRequest::writePacketData, CFeedRefreshRequest::readPacketData, CFeedRefreshRequest::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(58, SMerchantOffersPacket.class, SMerchantOffersPacket::writePacketData, SMerchantOffersPacket::readPacketData, SMerchantOffersPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(60, SOffersErrorPacket.class, SAbstractErrorPacket::writePacketData, SOffersErrorPacket::readPacketData, SOffersErrorPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(62, SAuthErrorPacket.class, SAbstractErrorPacket::writePacketData, SAuthErrorPacket::readPacketData, SAuthErrorPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(61, SOfferStatePacket.class, SOfferStatePacket::writePacketData, SOfferStatePacket::readPacketData, SOfferStatePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static boolean isThisProtocolAcceptedByClient(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    static {
        simpleChannelRL = new ResourceLocation("zettergallery", "zetter_channel");
    }
}

