/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import me.dantaeusb.zetter.core.ZetterBlocks;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ZetterGalleryVillagers {
    private static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"zettergallery");
    private static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"zettergallery");
    public static final RegistryObject<PoiType> PAINTING_MERCHANT_POI = POI_TYPES.register("artist_table", () -> new PoiType(ZetterGalleryVillagers.getAllStates((Block)ZetterBlocks.ARTIST_TABLE.get()), 1, 1));
    public static final RegistryObject<VillagerProfession> PAINTING_MERCHANT = VILLAGER_PROFESSIONS.register("painting_merchant", () -> {
        ResourceKey key = Objects.requireNonNull(PAINTING_MERCHANT_POI.getKey());
        return new VillagerProfession("painting_merchant", holder -> holder.m_203565_(key), holder -> holder.m_203565_(key), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12503_);
    });

    public static void init(IEventBus bus) {
        POI_TYPES.register(bus);
        VILLAGER_PROFESSIONS.register(bus);
    }

    private static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_());
    }
}

