/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.gallery;

import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.core.Helper;
import me.dantaeusb.zettergallery.gallery.AuthorizationCode;
import me.dantaeusb.zettergallery.gallery.GalleryServerCapability;
import me.dantaeusb.zettergallery.gallery.PlayerToken;
import me.dantaeusb.zettergallery.gallery.PlayerTokenStorage;
import me.dantaeusb.zettergallery.gallery.SalesManager;
import me.dantaeusb.zettergallery.gallery.ServerInfo;
import me.dantaeusb.zettergallery.gallery.Token;
import me.dantaeusb.zettergallery.network.http.GalleryConnection;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.network.http.dto.AuthTokenResponse;
import me.dantaeusb.zettergallery.network.http.dto.GenericMessageResponse;
import me.dantaeusb.zettergallery.network.http.dto.PaintingsResponse;
import me.dantaeusb.zettergallery.trading.PaintingMerchantSaleOffer;
import me.dantaeusb.zettergallery.util.EventConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public class ConnectionManager
implements AutoCloseable {
    public static final int TICKS_TO_REFRESH = 1200;
    @Nullable
    private static ConnectionManager instance;
    private final GalleryConnection connection;
    private final PlayerTokenStorage playerTokenStorage = PlayerTokenStorage.getInstance();
    private Level overworld;
    private ServerInfo serverInfo;
    private Token serverToken;
    private Token refreshToken;
    private UUID serverUuid;
    private ConnectionStatus status = ConnectionStatus.WAITING;
    private String errorMessage = "Connection is not ready";
    private long errorTimestamp;
    private long lastRefreshTimestamp;

    private ConnectionManager(Level overworld) {
        this.overworld = overworld;
        this.connection = new GalleryConnection();
        instance = this;
    }

    public static ConnectionManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Connection Manager is not ready, no client app capability in the world");
        }
        return instance;
    }

    public static void initialize(Level overworld) {
        instance = new ConnectionManager(overworld);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public static void closeConnection() {
        if (instance != null) {
            instance.close();
            instance = null;
        }
    }

    public void handleServerStart(MinecraftServer server) {
        this.serverInfo = server.m_6982_() ? ServerInfo.createMultiplayerServer(server.m_129916_(), server.m_7630_()) : ServerInfo.createSingleplayerServer(server.m_7630_());
    }

    public void handleServerStop(MinecraftServer server) {
        if (this.status == ConnectionStatus.READY) {
            this.dropServerToken();
        }
    }

    public void handleTick(MinecraftServer server) {
        if (this.status != ConnectionStatus.READY || System.currentTimeMillis() < this.lastRefreshTimestamp + 1200L) {
            return;
        }
        if (this.serverToken.needRefresh()) {
            this.refreshServerToken(this.refreshToken, token -> {}, arg_0 -> ((Logger)Zetter.LOG).error(arg_0));
        }
        this.playerTokenStorage.validateTokens();
        this.lastRefreshTimestamp = System.currentTimeMillis();
    }

    public GalleryConnection getConnection() {
        return this.connection;
    }

    private boolean hasToken() {
        return this.serverToken == null || !this.serverToken.valid();
    }

    private void registerServerPlayer(ServerPlayer player, Consumer<PlayerToken> tokenConsumer, Consumer<GalleryError> errorConsumer) {
        GalleryServerCapability galleryServerCapability = (GalleryServerCapability)Helper.getWorldGalleryCapability(this.overworld);
        this.connection.registerPlayer(this.serverToken.token, (Player)player, response -> {
            PlayerToken playerReservedToken = new PlayerToken(response.token.token, response.token.issuedAt, response.token.notAfter);
            if (response.poolingAuthorizationCode != null) {
                playerReservedToken.setAuthorizationCode(response.poolingAuthorizationCode);
            }
            this.playerTokenStorage.setPlayerToken(player, playerReservedToken);
            tokenConsumer.accept(playerReservedToken);
        }, errorConsumer);
    }

    private void requestAuthorizationCode(ServerPlayer player, Consumer<AuthorizationCode> authorizationCodeConsumer, Consumer<GalleryError> errorConsumer) {
        this.connection.requestServerPlayerAuthorizationCode(this.serverToken.token, authorizationCode -> {
            if (this.playerTokenStorage.getPlayerToken(player) == null) {
                ZetterGallery.LOG.error("No token to update authorization code");
            }
            this.playerTokenStorage.getPlayerToken(player).setAuthorizationCode((AuthorizationCode)authorizationCode);
            authorizationCodeConsumer.accept((AuthorizationCode)authorizationCode);
        }, errorConsumer);
    }

    public void authenticateServerPlayer(ServerPlayer player, Consumer<PlayerToken> successConsumer, Consumer<GalleryError> errorConsumer) {
        if (!this.authenticateServerClient(token -> this.authenticateServerPlayer(player, successConsumer, errorConsumer), errorConsumer)) {
            return;
        }
        if (this.playerTokenStorage.hasPlayerToken(player)) {
            PlayerToken playerToken = this.playerTokenStorage.getPlayerToken(player);
            assert (playerToken != null);
            if (!playerToken.valid()) {
                this.playerTokenStorage.removePlayerToken(player);
                this.registerServerPlayer(player, successConsumer, errorConsumer);
                return;
            }
            if (playerToken.isAuthorized() && playerToken.valid()) {
                successConsumer.accept(playerToken);
            } else if (playerToken.authorizationCode != null && playerToken.authorizationCode.valid()) {
                GalleryServerCapability galleryServerCapability = (GalleryServerCapability)Helper.getWorldGalleryCapability(this.overworld);
                this.connection.requestServerPlayerToken(galleryServerCapability.getClientInfo(), playerToken.token, playerToken.authorizationCode.code, authTokenResponse -> {
                    this.playerTokenStorage.removePlayerToken(player);
                    PlayerToken newPlayerToken = new PlayerToken(authTokenResponse.token, authTokenResponse.issuedAt, authTokenResponse.notAfter);
                    newPlayerToken.setAuthorizedAs(new PlayerToken.PlayerInfo(player.m_20148_(), player.m_7755_().getString()));
                    this.playerTokenStorage.setPlayerToken(player, newPlayerToken);
                    successConsumer.accept(newPlayerToken);
                }, error -> {
                    if (error.getCode() == 401) {
                        successConsumer.accept(playerToken);
                    } else {
                        ZetterGallery.LOG.error(error.getMessage());
                        playerToken.dropAuthorizationCode();
                        this.requestAuthorizationCode(player, authorizationCode -> this.authenticateServerPlayer(player, successConsumer, errorConsumer), errorConsumer);
                    }
                });
            } else {
                this.requestAuthorizationCode(player, authorizationCode -> this.authenticateServerPlayer(player, successConsumer, errorConsumer), errorConsumer);
            }
        } else {
            this.registerServerPlayer(player, successConsumer, errorConsumer);
        }
    }

    public void registerImpression(ServerPlayer player, UUID paintingUuid, int cycleId, EventConsumer successConsumer, EventConsumer errorConsumer) {
        ConnectionManager.getInstance().getConnection().registerImpression(this.playerTokenStorage.getPlayerTokenString(player), paintingUuid, cycleId, (GenericMessageResponse response) -> successConsumer.accept(), (GalleryError exception) -> errorConsumer.accept());
    }

    public void registerPurchase(ServerPlayer player, UUID paintingUuid, int price, int cycleId, EventConsumer successConsumer, Consumer<GalleryError> errorConsumer) {
        ConnectionManager.getInstance().getConnection().registerPurchase(this.playerTokenStorage.getPlayerTokenString(player), paintingUuid, price, cycleId, (GenericMessageResponse response) -> successConsumer.accept(), errorConsumer);
    }

    public void validateSale(ServerPlayer player, PaintingMerchantSaleOffer offer, EventConsumer successConsumer, Consumer<GalleryError> errorConsumer) {
        if (!SalesManager.getInstance().canPlayerSell((Player)player)) {
            errorConsumer.accept(new GalleryError(1003, "Sale is not allowed on this server"));
            return;
        }
        if (offer.isLoading()) {
            errorConsumer.accept(new GalleryError(1004, "Painting data not ready"));
            return;
        }
        ConnectionManager.getInstance().getConnection().validatePainting(this.playerTokenStorage.getPlayerTokenString(player), offer.getPaintingName(), (AbstractCanvasData)offer.getDummyPaintingData(), response -> successConsumer.accept(), errorConsumer);
    }

    public void registerSale(ServerPlayer player, PaintingMerchantSaleOffer offer, EventConsumer successConsumer, Consumer<GalleryError> errorConsumer) {
        if (!SalesManager.getInstance().canPlayerSell((Player)player)) {
            errorConsumer.accept(new GalleryError(1003, "Sale is not allowed on this server"));
            return;
        }
        if (offer.isLoading()) {
            errorConsumer.accept(new GalleryError(1004, "Painting data not ready"));
            return;
        }
        ConnectionManager.getInstance().getConnection().sellPainting(this.playerTokenStorage.getPlayerTokenString(player), offer.getPaintingName(), (AbstractCanvasData)offer.getDummyPaintingData(), response -> successConsumer.accept(), errorConsumer);
    }

    public void requestFeed(ServerPlayer player, Consumer<PaintingsResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.getConnection().getPlayerFeed(this.playerTokenStorage.getPlayerTokenString(player), successConsumer, errorConsumer);
    }

    private boolean authenticateServerClient(Consumer<Token> retryConsumer, @Nullable Consumer<GalleryError> errorConsumer) {
        if (this.status == ConnectionStatus.READY && this.serverToken.valid()) {
            if (this.serverToken.needRefresh()) {
                GalleryServerCapability galleryServerCapability = (GalleryServerCapability)Helper.getWorldGalleryCapability(this.overworld);
                if (galleryServerCapability.getClientInfo() != null) {
                    this.refreshServerToken(this.refreshToken, retryConsumer, errorConsumer);
                }
                return false;
            }
            return true;
        }
        if (this.status == ConnectionStatus.UNRECOVERABLE_ERROR) {
            if (errorConsumer != null) {
                errorConsumer.accept(new GalleryError(1001, this.errorMessage));
            }
            return false;
        }
        if (this.status == ConnectionStatus.ERROR && System.currentTimeMillis() <= this.errorTimestamp + 30000L) {
            if (errorConsumer != null) {
                errorConsumer.accept(new GalleryError(1001, this.errorMessage));
            }
            return false;
        }
        GalleryServerCapability galleryServerCapability = (GalleryServerCapability)Helper.getWorldGalleryCapability(this.overworld);
        if (galleryServerCapability.getClientInfo() != null) {
            this.getServerToken(galleryServerCapability.getClientInfo(), retryConsumer, errorConsumer);
        } else {
            this.createServerClient(() -> this.getServerToken(galleryServerCapability.getClientInfo(), retryConsumer, errorConsumer), errorConsumer);
        }
        return false;
    }

    private void createServerClient(EventConsumer successConsumer, @Nullable Consumer<GalleryError> errorConsumer) {
        GalleryServerCapability galleryServerCapability = (GalleryServerCapability)Helper.getWorldGalleryCapability(this.overworld);
        this.connection.createServerClient(this.serverInfo, serverResponse -> {
            if (serverResponse.client == null) {
                if (errorConsumer != null) {
                    errorConsumer.accept(new GalleryError(0, "Cannot find necessary client info in response"));
                }
                return;
            }
            galleryServerCapability.saveClientInfo(serverResponse.client);
            successConsumer.accept();
        }, error -> {
            if (error.getCode() == 403) {
                this.errorMessage = "Server's Zetter Gallery version is out of date. Please update.";
                this.status = ConnectionStatus.UNRECOVERABLE_ERROR;
            } else {
                this.errorMessage = "Cannot connect. Please try later.";
                this.status = ConnectionStatus.ERROR;
            }
            this.errorTimestamp = System.currentTimeMillis();
            error.setClientMessage(this.errorMessage);
            if (errorConsumer != null) {
                errorConsumer.accept((GalleryError)error);
            }
        });
    }

    private void getServerToken(GalleryServerCapability.ClientInfo clientInfo, Consumer<Token> retryConsumer, @Nullable Consumer<GalleryError> errorConsumer) {
        this.connection.requestToken(clientInfo, authTokenResponse -> {
            this.handleServerAuthorizationSuccess((AuthTokenResponse)authTokenResponse);
            retryConsumer.accept(this.serverToken);
        }, error -> {
            this.handleServerAuthorizationIssue((GalleryError)error);
            if (errorConsumer != null) {
                errorConsumer.accept((GalleryError)error);
            }
        });
    }

    private void refreshServerToken(Token refreshToken, Consumer<Token> retryConsumer, @Nullable Consumer<GalleryError> errorConsumer) {
        this.connection.refreshToken(refreshToken, authTokenResponse -> {
            this.handleServerAuthorizationSuccess((AuthTokenResponse)authTokenResponse);
            retryConsumer.accept(this.serverToken);
        }, error -> {
            this.handleServerAuthorizationIssue((GalleryError)error);
            if (errorConsumer != null) {
                errorConsumer.accept((GalleryError)error);
            }
        });
    }

    private void handleServerAuthorizationSuccess(AuthTokenResponse authTokenResponse) {
        this.serverToken = new Token(authTokenResponse.token, authTokenResponse.issuedAt, authTokenResponse.notAfter);
        if (authTokenResponse.refreshToken != null) {
            this.refreshToken = new Token(authTokenResponse.refreshToken.token, authTokenResponse.refreshToken.issuedAt, authTokenResponse.refreshToken.notAfter);
        }
        this.status = ConnectionStatus.READY;
    }

    private void handleServerAuthorizationIssue(GalleryError error) {
        if (error.getCode() == 400) {
            ZetterGallery.LOG.error("Unable to use existing refresh token got error: " + error.getMessage());
            if (this.serverToken != null) {
                this.serverToken = null;
                this.refreshToken = null;
            }
            GalleryServerCapability galleryServerCapability = (GalleryServerCapability)Helper.getWorldGalleryCapability(this.overworld);
            galleryServerCapability.removeClientInfo();
        }
        this.errorMessage = "Cannot connect. Please try later.";
        this.status = ConnectionStatus.ERROR;
        this.errorTimestamp = System.currentTimeMillis();
        error.setClientMessage(this.errorMessage);
    }

    private void dropServerToken() {
        this.playerTokenStorage.flush();
        this.connection.unregisterServer(this.serverToken.token, message -> {}, arg_0 -> ((Logger)Zetter.LOG).error(arg_0));
    }

    static enum ConnectionStatus {
        WAITING,
        READY,
        ERROR,
        UNRECOVERABLE_ERROR;

    }
}

