/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.gallery;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dantaeusb.zettergallery.core.ZetterGalleryCapabilities;
import me.dantaeusb.zettergallery.gallery.GalleryCapability;
import me.dantaeusb.zettergallery.gallery.GalleryServerCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class GalleryCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    private final GalleryCapability galleryCapability;
    private final String TAG_NAME_GALLERY_CAPABILITY = "ZetterGallery";

    public GalleryCapabilityProvider(Level world) {
        if (world.m_5776_()) {
            throw new IllegalArgumentException("Gallery capability exists only in server's overworld");
        }
        this.galleryCapability = new GalleryServerCapability(world);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (ZetterGalleryCapabilities.GALLERY == capability) {
            return LazyOptional.of(() -> this.galleryCapability);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.galleryCapability.getWorld() == null || this.galleryCapability.getWorld().m_5776_()) {
            return compoundTag;
        }
        Tag canvasTrackerTag = ((GalleryServerCapability)this.galleryCapability).serializeNBT();
        compoundTag.m_128365_("ZetterGallery", canvasTrackerTag);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        if (this.galleryCapability.getWorld() == null || this.galleryCapability.getWorld().m_5776_()) {
            return;
        }
        Tag galleryTag = compoundTag.m_128423_("ZetterGallery");
        ((GalleryServerCapability)this.galleryCapability).deserializeNBT(galleryTag);
    }
}

