/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.gallery;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import me.dantaeusb.zettergallery.gallery.GalleryCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class GalleryServerCapability
implements GalleryCapability {
    private static final String NBT_TAG_PAINTINGS_TRACKER = "PaintingsTracker";
    private static final String NBT_TAG_CLIENT_ID = "ClientID";
    private static final String NBT_TAG_CLIENT_NAME = "ClientName";
    private static final String NBT_TAG_CLIENT_SECRET = "ClientSecret";
    private Level overworld;
    @Nullable
    private ClientInfo clientInfo;

    public GalleryServerCapability(Level overworld) {
        this.overworld = overworld;
    }

    @Override
    public Level getWorld() {
        return this.overworld;
    }

    public void saveClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public void removeClientInfo() {
        this.clientInfo = null;
    }

    @Nullable
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public Tag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.clientInfo != null) {
            this.clientInfo.serialize(compound);
        }
        return compound;
    }

    public void deserializeNBT(Tag tag) {
        CompoundTag compound;
        if (tag.m_6458_() == CompoundTag.f_128326_ && (compound = (CompoundTag)tag).m_128441_(NBT_TAG_CLIENT_ID) && compound.m_128441_(NBT_TAG_CLIENT_SECRET)) {
            this.clientInfo = ClientInfo.deserialize(compound);
        }
    }

    public static class ClientInfo {
        public String id;
        public String name;
        public String secret;

        public ClientInfo(String id, String name, String secret) {
            this.id = id;
            this.name = name;
            this.secret = secret;
        }

        public void serialize(CompoundTag compound) {
            compound.m_128359_(GalleryServerCapability.NBT_TAG_CLIENT_ID, this.id);
            compound.m_128359_(GalleryServerCapability.NBT_TAG_CLIENT_NAME, this.name);
            compound.m_128359_(GalleryServerCapability.NBT_TAG_CLIENT_SECRET, this.secret);
        }

        public static ClientInfo deserialize(CompoundTag compound) {
            String clientId = compound.m_128461_(GalleryServerCapability.NBT_TAG_CLIENT_ID);
            String clientName = compound.m_128461_(GalleryServerCapability.NBT_TAG_CLIENT_NAME);
            String clientSecret = compound.m_128461_(GalleryServerCapability.NBT_TAG_CLIENT_SECRET);
            return new ClientInfo(clientId, clientName, clientSecret);
        }
    }

    public static class PaintingTracker {
        public Long updatedAt;
        public List<UUID> connectedEntities = new ArrayList<UUID>();

        public PaintingTracker(UUID entityId, Long updatedAt) {
            this.updatedAt = updatedAt;
            this.connectedEntities.add(entityId);
        }

        public void serialize(CompoundTag compoundTag) {
        }
    }
}

