/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.gallery;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.dantaeusb.zettergallery.gallery.PlayerToken;
import net.minecraft.server.level.ServerPlayer;

public class PlayerTokenStorage {
    private static PlayerTokenStorage instance;
    private final HashMap<UUID, PlayerToken> playerTokenMap = new HashMap();

    public static PlayerTokenStorage getInstance() {
        if (instance == null) {
            instance = new PlayerTokenStorage();
        }
        return instance;
    }

    public void validateTokens() {
        Date now = new Date();
        if (this.playerTokenMap.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, PlayerToken> entry2 : this.playerTokenMap.entrySet()) {
            if (entry2.getValue().notAfter.before(now)) {
                this.playerTokenMap.remove(entry2.getKey());
            }
            if (entry2.getValue().needRefresh()) {
                // empty if block
            }
            if (entry2.getValue().authorizationCode == null || !entry2.getValue().authorizationCode.notAfter.before(now)) continue;
            entry2.getValue().dropAuthorizationCode();
        }
        this.playerTokenMap.entrySet().removeIf(entry -> ((PlayerToken)entry.getValue()).notAfter.before(now));
    }

    public int getSize() {
        return this.playerTokenMap.size();
    }

    public void flush() {
        this.playerTokenMap.clear();
    }

    public void setPlayerToken(ServerPlayer playerEntity, PlayerToken token) {
        this.playerTokenMap.put(playerEntity.m_20148_(), token);
    }

    public boolean hasPlayerToken(ServerPlayer playerEntity) {
        return this.playerTokenMap.containsKey(playerEntity.m_20148_());
    }

    public void removePlayerToken(ServerPlayer playerEntity) {
        this.playerTokenMap.remove(playerEntity.m_20148_());
    }

    @Nullable
    public PlayerToken getPlayerToken(ServerPlayer playerEntity) {
        UUID playerId = playerEntity.m_20148_();
        if (!this.playerTokenMap.containsKey(playerId)) {
            return null;
        }
        return this.playerTokenMap.get(playerId);
    }

    @Nullable
    public String getPlayerTokenString(ServerPlayer playerEntity) {
        UUID playerId = playerEntity.m_20148_();
        if (!this.playerTokenMap.containsKey(playerId)) {
            return null;
        }
        return this.playerTokenMap.get((Object)playerId).token;
    }
}

