/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.gallery;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.container.PaintingMerchantContainer;
import me.dantaeusb.zettergallery.gallery.ConnectionManager;
import me.dantaeusb.zettergallery.gallery.salesmanager.PlayerFeed;
import me.dantaeusb.zettergallery.menu.PaintingMerchantMenu;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.network.http.dto.PaintingsResponse;
import me.dantaeusb.zettergallery.trading.PaintingMerchantPurchaseOffer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SalesManager {
    @Nullable
    private static SalesManager instance;
    private final HashMap<Integer, PaintingsResponse.CycleInfo> cycles = new HashMap();
    private final HashMap<UUID, PlayerFeed> playerFeeds = new HashMap();
    private final List<ServerPlayer> trackingPlayers = new ArrayList<ServerPlayer>();
    private Integer currentCycleIncrementId = null;
    private int tick = 0;
    private final List<UUID> playersWaitingUpdateUuid = new ArrayList<UUID>();

    private SalesManager() {
        instance = this;
    }

    public static SalesManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Painting Feed Manager is not ready, no client app capability in the world");
        }
        return instance;
    }

    public static void initialize() {
        instance = new SalesManager();
    }

    public static void close() {
        instance = null;
    }

    public void registerTrackingPlayer(ServerPlayer player) {
        if (this.trackingPlayers.contains(player)) {
            return;
        }
        this.trackingPlayers.add(player);
    }

    public void unregisterTrackingPlayer(ServerPlayer player) {
        if (!this.trackingPlayers.contains(player)) {
            return;
        }
        this.trackingPlayers.remove(player);
    }

    @Nullable
    public PaintingsResponse.CycleInfo getCycleInfo(int cycleIncrementId) {
        if (!this.cycles.containsKey(cycleIncrementId)) {
            return null;
        }
        return this.cycles.get(cycleIncrementId);
    }

    @Nullable
    public PaintingsResponse.CycleInfo getCurrentCycleInfo() {
        if (this.currentCycleIncrementId == null) {
            return null;
        }
        if (!this.cycles.containsKey(this.currentCycleIncrementId)) {
            return null;
        }
        PaintingsResponse.CycleInfo currentCycle = this.cycles.get(this.currentCycleIncrementId);
        if (new Date().getTime() > currentCycle.endsAt.getTime()) {
            return null;
        }
        return currentCycle;
    }

    public void tick() {
        if (++this.tick % 30 != 0) {
            return;
        }
        if (this.trackingPlayers.isEmpty()) {
            return;
        }
        Iterator<ServerPlayer> trackingPlayerIterator = this.trackingPlayers.iterator();
        do {
            ServerPlayer trackingPlayer = trackingPlayerIterator.next();
            AbstractContainerMenu abstractContainerMenu = trackingPlayer.f_36096_;
            if (!(abstractContainerMenu instanceof PaintingMerchantMenu)) {
                ZetterGallery.LOG.warn("Player " + trackingPlayer.m_7755_().getString() + " does not have Painting Merchant Menu opened, but not unregistered!");
                trackingPlayerIterator.remove();
                continue;
            }
            PaintingMerchantMenu paintingMerchantMenu = (PaintingMerchantMenu)abstractContainerMenu;
            if (!paintingMerchantMenu.getContainer().canUpdate()) continue;
            this.acquireMerchantOffers(trackingPlayer, ((PaintingMerchantMenu)trackingPlayer.f_36096_).getContainer(), (cycle, feed) -> {
                if (paintingMerchantMenu.getContainer().needUpdate()) {
                    paintingMerchantMenu.getContainer().handleFeed((PaintingsResponse.CycleInfo)cycle, (List<PaintingMerchantPurchaseOffer>)feed);
                }
            }, error -> ((PaintingMerchantMenu)trackingPlayer.f_36096_).getContainer().handleError((GalleryError)error));
        } while (trackingPlayerIterator.hasNext());
        if (this.tick % 5 * 60 * 20 == 0) {
            this.cleanup();
        }
    }

    private void cleanup() {
        this.cycles.entrySet().removeIf(cycleInfoEntry -> new Date().getTime() - ((PaintingsResponse.CycleInfo)cycleInfoEntry.getValue()).endsAt.getTime() > 1800000L);
        this.playerFeeds.entrySet().removeIf(playerFeedEntry -> !this.cycles.containsKey(((PlayerFeed)playerFeedEntry.getValue()).getCycleIncrementId()));
    }

    public boolean canPlayerSell(Player player) {
        if (this.playerFeeds.containsKey(player.m_20148_())) {
            PlayerFeed feed = this.playerFeeds.get(player.m_20148_());
            return feed.isSaleAllowed();
        }
        return false;
    }

    @Nullable
    public PlayerFeed getPlayerFeed(Player player) {
        if (this.playerFeeds.containsKey(player.m_20148_())) {
            PlayerFeed feed = this.playerFeeds.get(player.m_20148_());
            if (!this.cycles.containsKey(feed.getCycleIncrementId())) {
                return null;
            }
            if (this.cycles.get((Object)Integer.valueOf((int)feed.getCycleIncrementId())).endsAt.getTime() < new Date().getTime()) {
                return null;
            }
            return feed;
        }
        return null;
    }

    public void acquireMerchantOffers(ServerPlayer player, PaintingMerchantContainer paintingMerchantContainer, BiConsumer<PaintingsResponse.CycleInfo, List<PaintingMerchantPurchaseOffer>> successConsumer, Consumer<GalleryError> errorConsumer) {
        PlayerFeed feed = this.getPlayerFeed((Player)player);
        if (feed != null) {
            PaintingsResponse.CycleInfo cycle = this.cycles.get(feed.getCycleIncrementId());
            List<PaintingMerchantPurchaseOffer> offers = this.getOffersFromFeed(cycle.seed, feed, paintingMerchantContainer.getMenu().getMerchantId(), paintingMerchantContainer.getMenu().getMerchantLevel());
            successConsumer.accept(cycle, offers);
        } else {
            if (this.playersWaitingUpdateUuid.contains(player.m_20148_())) {
                if (ZetterGallery.DEBUG_MODE) {
                    ZetterGallery.LOG.warn("Discarding player request for the new feed as it's already queried");
                }
                return;
            }
            ConnectionManager.getInstance().requestFeed(player, paintingsResponse -> {
                this.playersWaitingUpdateUuid.remove(player.m_20148_());
                PaintingsResponse.CycleInfo cycleInfo = this.processCurrentCycleInfo(paintingsResponse.cycleInfo);
                PlayerFeed playerFeed = this.createPlayerFeed(player, (PaintingsResponse)paintingsResponse);
                List<PaintingMerchantPurchaseOffer> offers = this.getOffersFromFeed(cycleInfo.seed, playerFeed, paintingMerchantContainer.getMenu().getMerchantId(), paintingMerchantContainer.getMenu().getMerchantLevel());
                successConsumer.accept(cycleInfo, offers);
            }, error -> {
                this.playersWaitingUpdateUuid.remove(player.m_20148_());
                errorConsumer.accept((GalleryError)error);
            });
            this.playersWaitingUpdateUuid.add(player.m_20148_());
        }
    }

    private PaintingsResponse.CycleInfo processCurrentCycleInfo(PaintingsResponse.CycleInfo cycleInfo) {
        if (this.cycles.containsKey(cycleInfo.incrementId)) {
            if (!this.cycles.get((Object)Integer.valueOf((int)cycleInfo.incrementId)).seed.equals(cycleInfo.seed)) {
                throw new IllegalStateException("Got a new cycle with the same id as the current cycle, but data differs.");
            }
            return cycleInfo;
        }
        long currentEpochTime = new Date().getTime();
        if (cycleInfo.endsAt.getTime() < currentEpochTime || cycleInfo.startsAt.getTime() > currentEpochTime) {
            throw new IllegalStateException("Got a new cycle, but the system time is out of cycle bounds! Please check system time.");
        }
        this.cycles.put(cycleInfo.incrementId, cycleInfo);
        this.currentCycleIncrementId = cycleInfo.incrementId;
        return cycleInfo;
    }

    private PlayerFeed createPlayerFeed(ServerPlayer player, PaintingsResponse response) {
        PlayerFeed feed = PlayerFeed.createFeedFromSaleResponse(player, response);
        this.playerFeeds.put(player.m_20148_(), feed);
        return feed;
    }

    private List<PaintingMerchantPurchaseOffer> getOffersFromFeed(String seed, PlayerFeed feed, UUID merchantId, int merchantLevel) {
        ByteBuffer buffer = ByteBuffer.wrap(seed.getBytes(StandardCharsets.UTF_8), 0, 8);
        long seedLong = buffer.getLong();
        Random rng = new Random(seedLong ^ feed.getPlayer().m_20148_().getMostSignificantBits() ^ merchantId.getMostSignificantBits());
        int totalCount = feed.getOffersCount();
        int showCount = 5 + merchantLevel * 2;
        showCount = Math.min(showCount, totalCount);
        List available = IntStream.range(0, totalCount).boxed().collect(Collectors.toList());
        Collections.shuffle(available, rng);
        available = available.subList(0, showCount);
        List<PaintingMerchantPurchaseOffer> randomOffers = available.stream().map(feed.getOffers()::get).toList();
        LinkedList<String> offerIds = new LinkedList<String>();
        LinkedList<PaintingMerchantPurchaseOffer> offers = new LinkedList<PaintingMerchantPurchaseOffer>();
        for (PaintingMerchantPurchaseOffer offer : randomOffers) {
            if (offerIds.contains(offer.getDummyCanvasCode())) continue;
            offerIds.add(offer.getDummyCanvasCode());
            offers.add(offer);
        }
        return offers;
    }
}

