/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.menu;

import java.util.UUID;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.container.PaintingMerchantContainer;
import me.dantaeusb.zettergallery.core.ZetterGalleryContainerMenus;
import me.dantaeusb.zettergallery.gallery.ConnectionManager;
import me.dantaeusb.zettergallery.menu.paintingmerchant.MerchantAuthorizationController;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.trading.PaintingMerchantOffer;
import me.dantaeusb.zettergallery.trading.PaintingMerchantPurchaseOffer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.npc.ClientSideMerchant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;

public class PaintingMerchantMenu
extends AbstractContainerMenu
implements ContainerListener {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    public static final int PLAYER_INVENTORY_XPOS = 24;
    public static final int PLAYER_INVENTORY_YPOS = 154;
    private final Player player;
    private final Merchant merchant;
    private final MerchantAuthorizationController authorizationController;
    private final PaintingMerchantContainer container;
    private UUID merchantId;
    private int merchantLevel;

    private PaintingMerchantMenu(int windowID, Inventory invPlayer, Merchant merchant) {
        super((MenuType)ZetterGalleryContainerMenus.PAINTING_MERCHANT.get(), windowID);
        this.player = invPlayer.f_35978_;
        this.merchant = merchant;
        this.container = new PaintingMerchantContainer(invPlayer.f_35978_, merchant, this);
        this.container.addListener(this);
        this.authorizationController = new MerchantAuthorizationController(invPlayer.f_35978_, this);
        int INPUT_XPOS = 119;
        int INPUT_YPOS = 119;
        int OUTPUT_XPOS = 180;
        int OUTPUT_YPOS = 119;
        this.m_38897_(new SlotInput(this.container, 0, 119, 119));
        this.m_38897_(new SlotOutput(this.container, 1, 180, 119));
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 24;
        int HOTBAR_YPOS = 212;
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)invPlayer, x, 24 + 18 * x, 212));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 24 + x * 18;
                int ypos = 154 + y * 18;
                this.m_38897_(new Slot((Container)invPlayer, slotNumber, xpos, ypos));
            }
        }
    }

    public static PaintingMerchantMenu createMenuServerSide(int windowID, Inventory playerInventory, Merchant merchant) {
        return new PaintingMerchantMenu(windowID, playerInventory, merchant);
    }

    public static PaintingMerchantMenu createMenuClientSide(int windowID, Inventory playerInventory, FriendlyByteBuf networkBuffer) {
        ClientSideMerchant merchant = new ClientSideMerchant(playerInventory.f_35978_);
        return new PaintingMerchantMenu(windowID, playerInventory, (Merchant)merchant);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Merchant getMerchant() {
        return this.merchant;
    }

    public PaintingMerchantContainer getContainer() {
        return this.container;
    }

    public MerchantAuthorizationController getAuthController() {
        return this.authorizationController;
    }

    public void setMerchantLevel(int level) {
        this.merchantLevel = level;
    }

    public void setXp(int pXp) {
        this.merchant.m_6621_(pXp);
    }

    public void setOffers(MerchantOffers pOffers) {
        this.merchant.m_6255_(pOffers);
    }

    public int getMerchantLevel() {
        return this.merchantLevel;
    }

    public void setMerchantId(UUID uuid) {
        this.merchantId = uuid;
    }

    public UUID getMerchantId() {
        return this.merchantId;
    }

    public void m_5757_(Container container) {
    }

    public void purchase(Player player, ItemStack stack) {
        this.container.checkout(stack);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player playerIn, int sourceSlotIndex) {
        ItemStack outStack = ItemStack.f_41583_;
        Slot sourceSlot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.m_6657_()) {
            ItemStack sourceStack = sourceSlot.m_7993_();
            outStack = sourceStack.m_41777_();
            if (sourceSlotIndex == 0) {
                if (!this.m_38903_(sourceStack, 2, 10, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (sourceStack.m_41720_() == ZetterItems.PALETTE.get()) {
                if (!this.m_38903_(sourceStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41619_()) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
            if (sourceStack.m_41613_() == outStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            sourceSlot.m_142406_(playerIn, sourceStack);
        }
        return outStack;
    }

    public boolean hasOffers() {
        return this.container.hasOffers();
    }

    public int getOffersCount() {
        return this.container.getOffersCount();
    }

    @Nullable
    public PaintingMerchantOffer getCurrentOffer() {
        return this.container.getCurrentOffer();
    }

    public void updateCurrentOfferIndex(int index) {
        this.container.setSelectedPurchaseOfferIndex(index);
        if (!this.merchant.m_183595_()) {
            PaintingMerchantPurchaseOffer currentPurchaseOffer = this.container.getCurrentPurchaseOffer();
            assert (currentPurchaseOffer != null);
            ConnectionManager.getInstance().registerImpression((ServerPlayer)this.player, currentPurchaseOffer.getPaintingUuid(), currentPurchaseOffer.getCycleIncrementId(), () -> {}, () -> ZetterGallery.LOG.error("Unable to register impression, maybe outdated mod version?"));
        }
    }

    public int getCurrentOfferIndex() {
        return this.container.getSelectedPurchaseOfferIndex();
    }

    public void handleOfferState(String canvasCode, PaintingMerchantOffer.State state, String message) {
        if (this.getCurrentOffer() == null || !this.getCurrentOffer().getDummyCanvasCode().equals(canvasCode)) {
            return;
        }
        if (state == PaintingMerchantOffer.State.ERROR) {
            this.getCurrentOffer().markError(new GalleryError(1005, message));
        } else if (state == PaintingMerchantOffer.State.READY) {
            this.getCurrentOffer().ready();
        }
        this.container.m_6596_();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!this.merchant.m_183595_()) {
            if (!player.m_6084_() || player instanceof ServerPlayer && ((ServerPlayer)player).m_9232_()) {
                ItemStack itemstack = this.container.m_8016_(0);
                if (!itemstack.m_41619_()) {
                    player.m_36176_(itemstack, false);
                }
                if (!(itemstack = this.container.m_8016_(1)).m_41619_()) {
                    player.m_36176_(itemstack, false);
                }
            } else {
                player.m_150109_().m_150079_(this.container.m_8016_(0));
            }
        }
        this.container.removed();
        this.merchant.m_7189_(null);
    }

    private boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_() && ItemStack.m_41656_((ItemStack)stack1, (ItemStack)stack2);
    }

    public class SlotInput
    extends Slot {
        public SlotInput(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            if (!PaintingMerchantMenu.this.hasOffers()) {
                return false;
            }
            if (!PaintingMerchantMenu.this.container.m_7013_(0, stack)) {
                return false;
            }
            if (stack.m_41720_() == Items.f_42616_) {
                return true;
            }
            return stack.m_41720_() == ZetterItems.PAINTING.get() && PaintingMerchantMenu.this.getAuthController().canSell(stack);
        }

        public boolean m_8010_(Player player) {
            return PaintingMerchantMenu.this.container.canTakeItem(0);
        }
    }

    public class SlotOutput
    extends Slot {
        public SlotOutput(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            PaintingMerchantMenu.this.purchase(player, stack);
        }
    }
}

