/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.menu.paintingmerchant;

import javax.annotation.Nullable;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.core.ZetterGalleryNetwork;
import me.dantaeusb.zettergallery.gallery.AuthorizationCode;
import me.dantaeusb.zettergallery.gallery.ConnectionManager;
import me.dantaeusb.zettergallery.gallery.PlayerToken;
import me.dantaeusb.zettergallery.menu.PaintingMerchantMenu;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.network.packet.CAuthorizationCheckPacket;
import me.dantaeusb.zettergallery.network.packet.SAuthErrorPacket;
import me.dantaeusb.zettergallery.network.packet.SAuthenticationPlayerResponsePacket;
import me.dantaeusb.zettergallery.network.packet.SAuthorizationCodeResponsePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class MerchantAuthorizationController {
    @Nullable
    private PlayerToken.PlayerInfo playerInfo;
    @Nullable
    private AuthorizationCode authorizationCode;
    private boolean canSell = true;
    private final Player player;
    private final PaintingMerchantMenu menu;
    private PlayerAuthorizationState state = PlayerAuthorizationState.SERVER_AUTHENTICATION;
    private GalleryError error;

    public MerchantAuthorizationController(Player player, PaintingMerchantMenu menu) {
        this.player = player;
        this.menu = menu;
    }

    public PaintingMerchantMenu getMenu() {
        return this.menu;
    }

    public boolean isAuthorized() {
        return this.playerInfo != null;
    }

    @Nullable
    public PlayerToken.PlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    @Nullable
    public AuthorizationCode getAuthorizationCode() {
        return this.authorizationCode;
    }

    public PlayerAuthorizationState getState() {
        return this.state;
    }

    public boolean hasError() {
        return this.state == PlayerAuthorizationState.ERROR;
    }

    @Nullable
    public GalleryError getError() {
        if (this.hasError()) {
            if (this.error == null) {
                this.error = new GalleryError(0, "Something went wrong");
            }
            return this.error;
        }
        return null;
    }

    public boolean canSell(ItemStack painting) {
        return this.isAuthorized() && this.canSell && PaintingItem.getPaintingCode((ItemStack)painting) != null;
    }

    public void startFlow() {
        ConnectionManager.getInstance().authenticateServerPlayer((ServerPlayer)this.player, this::handleServerAuthentication, this::handleError);
    }

    private void handleServerAuthentication(PlayerToken playerToken) {
        PlayerAuthorizationState previousState = this.getState();
        if (playerToken.isAuthorized()) {
            this.handleAuthorized(playerToken.getAuthorizedAs());
        } else if (playerToken.getAuthorizationCode() != null) {
            this.handleUnauthorized(playerToken.getAuthorizationCode());
        }
        if (previousState == PlayerAuthorizationState.SERVER_AUTHENTICATION) {
            this.menu.getContainer().requestFeed();
        }
    }

    public void handleAuthorized(PlayerToken.PlayerInfo authorizedAs) {
        this.state = this.state.authorized();
        this.assertTargetState(PlayerAuthorizationState.LOGGED_IN);
        this.authorizationCode = null;
        this.playerInfo = authorizedAs;
        if (!this.player.m_7578_()) {
            SAuthenticationPlayerResponsePacket authorizationPacket = new SAuthenticationPlayerResponsePacket(authorizedAs);
            ZetterGalleryNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)authorizationPacket);
        }
    }

    public void handleUnauthorized(AuthorizationCode authorizationCodeInfo) {
        this.state = this.state.unauthorized();
        this.assertTargetState(PlayerAuthorizationState.CLIENT_AUTHORIZATION);
        this.authorizationCode = authorizationCodeInfo;
        if (!this.player.m_7578_()) {
            SAuthorizationCodeResponsePacket authorizationRequestPacket = new SAuthorizationCodeResponsePacket(authorizationCodeInfo);
            ZetterGalleryNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)authorizationRequestPacket);
        }
    }

    public void handleAuthorizationRetry() {
        this.state = this.state.retry();
        this.assertTargetState(PlayerAuthorizationState.SERVER_AUTHENTICATION);
        if (this.player.m_7578_()) {
            CAuthorizationCheckPacket authenticationCheckPacket = new CAuthorizationCheckPacket();
            ZetterGalleryNetwork.simpleChannel.sendToServer((Object)authenticationCheckPacket);
        } else {
            this.startFlow();
        }
    }

    public void handleError(GalleryError error) {
        PlayerAuthorizationState previousState = this.getState();
        this.error = error;
        this.state = this.state.error();
        if (previousState == PlayerAuthorizationState.SERVER_AUTHENTICATION) {
            this.menu.getContainer().handleError(this.error);
        }
        if (!this.player.m_7578_()) {
            SAuthErrorPacket selectOfferPacket = new SAuthErrorPacket(this.error);
            ZetterGalleryNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)selectOfferPacket);
        }
    }

    private void assertTargetState(PlayerAuthorizationState state) {
        if (this.state != state) {
            if (this.state != PlayerAuthorizationState.ERROR) {
                throw new IllegalStateException("Unexpected state transition");
            }
            if (this.error == null) {
                this.error = new GalleryError(2000, "Invalid state");
            }
            ZetterGallery.LOG.error("Ended up in invalid state, expected: " + state.toString());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum PlayerAuthorizationState {
        SERVER_AUTHENTICATION{

            @Override
            public PlayerAuthorizationState unauthorized() {
                return CLIENT_AUTHORIZATION;
            }

            @Override
            public PlayerAuthorizationState authorized() {
                return LOGGED_IN;
            }
        }
        ,
        CLIENT_AUTHORIZATION{

            @Override
            public PlayerAuthorizationState retry() {
                return SERVER_AUTHENTICATION;
            }
        }
        ,
        LOGGED_IN,
        ERROR;


        public PlayerAuthorizationState error() {
            return ERROR;
        }

        public PlayerAuthorizationState retry() {
            return ERROR;
        }

        public PlayerAuthorizationState unauthorized() {
            return ERROR;
        }

        public PlayerAuthorizationState authorized() {
            return ERROR;
        }
    }
}

