/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.http;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.gallery.AuthorizationCode;
import me.dantaeusb.zettergallery.gallery.GalleryServerCapability;
import me.dantaeusb.zettergallery.gallery.ServerInfo;
import me.dantaeusb.zettergallery.gallery.Token;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.network.http.GalleryException;
import me.dantaeusb.zettergallery.network.http.dto.AuthCheckResponse;
import me.dantaeusb.zettergallery.network.http.dto.AuthTokenResponse;
import me.dantaeusb.zettergallery.network.http.dto.GenericMessageResponse;
import me.dantaeusb.zettergallery.network.http.dto.ImpressionRequest;
import me.dantaeusb.zettergallery.network.http.dto.PaintingsResponse;
import me.dantaeusb.zettergallery.network.http.dto.PurchaseRequest;
import me.dantaeusb.zettergallery.network.http.dto.SaleRequest;
import me.dantaeusb.zettergallery.network.http.dto.ServerPlayerRegisterRequest;
import me.dantaeusb.zettergallery.network.http.dto.ServerPlayerResponse;
import me.dantaeusb.zettergallery.network.http.dto.ServerRegisterRequest;
import me.dantaeusb.zettergallery.network.http.dto.ServerResponse;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;

public class GalleryConnection
implements AutoCloseable {
    private static final String API_VERSION = "v1";
    private static final String SERVERS_ENDPOINT = "servers";
    private static final String SERVERS_PLAYERS_ENDPOINT = "servers/players";
    private static final String SERVERS_PLAYERS_TOKEN_ENDPOINT = "servers/players/token";
    private static final String SERVERS_PLAYERS_AUTHORIZATION_CODE_ENDPOINT = "servers/players/authorization-code";
    private static final String CLIENTS_ENDPOINT = "clients";
    private static final String TOKEN_ENDPOINT = "auth/token";
    private static final String CHECK_ENDPOINT = "auth/token/check";
    private static final String REVOKE_ENDPOINT = "auth/token/revoke";
    private static final String PAINTINGS_ENDPOINT = "paintings";
    private static final String PAINTINGS_PURCHASES_ENDPOINT = "sales";
    private static final String PAINTINGS_IMPRESSION_ENDPOINT = "impressions";
    private static final String PAINTINGS_FEED_ENDPOINT = "paintings/feed";
    private static final Gson GSON = new Gson();
    private final ExecutorService poolExecutor = Executors.newSingleThreadExecutor();

    @Override
    public void close() {
        this.poolExecutor.shutdownNow();
    }

    public void createServerClient(ServerInfo serverInfo, Consumer<ServerResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                ServerRegisterRequest request = new ServerRegisterRequest(serverInfo.singleplayer, serverInfo.motd, serverInfo.gameVersion, serverInfo.galleryVersion);
                URL authUri = GalleryConnection.getUri(SERVERS_ENDPOINT);
                ServerResponse response = GalleryConnection.makeRequest(authUri, "POST", ServerResponse.class, null, request);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to register server client app, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to register server client app: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void requestToken(GalleryServerCapability.ClientInfo clientInfo, Consumer<AuthTokenResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("grantType", "client_credentials");
                query.put("clientId", clientInfo.id);
                query.put("clientSecret", clientInfo.secret);
                query.put("scope", "server");
                query.put("requestRefresh", "true");
                URL authUri = GalleryConnection.getUri(TOKEN_ENDPOINT, query);
                AuthTokenResponse response = GalleryConnection.makeRequest(authUri, "GET", AuthTokenResponse.class, null, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to exchange token for server, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to exchange token for server: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void refreshToken(Token refreshToken, Consumer<AuthTokenResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("grantType", "refresh_token");
                query.put("refreshToken", refreshToken.token);
                query.put("requestRefresh", "true");
                URL authUri = GalleryConnection.getUri(TOKEN_ENDPOINT, query);
                AuthTokenResponse response = GalleryConnection.makeRequest(authUri, "GET", AuthTokenResponse.class, null, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to exchange token for server, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to exchange token for server: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void unregisterServer(String serverToken, Consumer<GenericMessageResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                URL authUri = GalleryConnection.getUri(REVOKE_ENDPOINT);
                GenericMessageResponse response = GalleryConnection.makeRequest(authUri, "DELETE", GenericMessageResponse.class, serverToken, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to drop server token, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to drop server token: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void registerPlayer(String serverToken, Player serverPlayer, Consumer<ServerPlayerResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                ServerPlayerRegisterRequest request = new ServerPlayerRegisterRequest(serverPlayer.m_20148_(), serverPlayer.m_7755_().getString());
                URL authUri = GalleryConnection.getUri(SERVERS_PLAYERS_ENDPOINT);
                ServerPlayerResponse response = GalleryConnection.makeRequest(authUri, "POST", ServerPlayerResponse.class, serverToken, request);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to request player token, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), "Unable to request player token")));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to request player token: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, "Unable to request player token")));
            }
        });
    }

    public void requestServerPlayerToken(GalleryServerCapability.ClientInfo clientInfo, String currentToken, String authorizationCode, Consumer<AuthTokenResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("grantType", "authorization_code");
                query.put("clientId", clientInfo.id);
                query.put("clientSecret", clientInfo.secret);
                query.put("authorizationCode", authorizationCode);
                query.put("scope", "player_server");
                query.put("requestRefresh", "true");
                URL authUri = GalleryConnection.getUri(SERVERS_PLAYERS_TOKEN_ENDPOINT, query);
                AuthTokenResponse response = GalleryConnection.makeRequest(authUri, "GET", AuthTokenResponse.class, currentToken, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to exchange token for server player, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to exchange token for server player: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void requestServerPlayerAuthorizationCode(String serverToken, Consumer<AuthorizationCode> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                URL authUri = GalleryConnection.getUri(SERVERS_PLAYERS_AUTHORIZATION_CODE_ENDPOINT);
                AuthorizationCode response = GalleryConnection.makeRequest(authUri, "GET", AuthorizationCode.class, serverToken, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable get authorization code for server player, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable get authorization code for server player: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void checkPlayerToken(String token, Consumer<AuthCheckResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                URL checkUri = GalleryConnection.getUri(CHECK_ENDPOINT);
                AuthCheckResponse response = GalleryConnection.makeRequest(checkUri, "GET", AuthCheckResponse.class, token, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to request player token, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to request player token: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void dropPlayerToken(String token, Consumer<GenericMessageResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                URL checkUri = GalleryConnection.getUri(REVOKE_ENDPOINT);
                GenericMessageResponse response = GalleryConnection.makeRequest(checkUri, "GET", GenericMessageResponse.class, token, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to drop player token, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to drop player token: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void getPlayerFeed(String token, Consumer<PaintingsResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                URL saleUri = GalleryConnection.getUri(PAINTINGS_FEED_ENDPOINT);
                PaintingsResponse response = GalleryConnection.makeRequest(saleUri, "GET", PaintingsResponse.class, token, null);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to request player feed, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to request player feed: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void registerImpression(String token, UUID paintingUuid, int cycleId, Consumer<GenericMessageResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                ImpressionRequest request = new ImpressionRequest(cycleId);
                URL impressionUri = GalleryConnection.getUri("paintings/" + paintingUuid.toString() + "/impressions");
                GenericMessageResponse response = GalleryConnection.makeRequest(impressionUri, "POST", GenericMessageResponse.class, token, request);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to register player impression, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to register player impression: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void registerPurchase(String token, UUID paintingUuid, int price, int cycleId, Consumer<GenericMessageResponse> success, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                PurchaseRequest request = new PurchaseRequest(price, cycleId);
                URL saleUri = GalleryConnection.getUri("paintings/" + paintingUuid.toString() + "/sales");
                GenericMessageResponse response = GalleryConnection.makeRequest(saleUri, "POST", GenericMessageResponse.class, token, request);
                executor.m_18689_(() -> success.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to register player purchase, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to register player purchase: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void validatePainting(String token, String paintingName, AbstractCanvasData paintingData, Consumer<PaintingsResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                SaleRequest request = new SaleRequest(paintingName, paintingData);
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("save", "false");
                URL validateUri = GalleryConnection.getUri(PAINTINGS_ENDPOINT, query);
                PaintingsResponse response = GalleryConnection.makeRequest(validateUri, "POST", PaintingsResponse.class, token, request);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to validate player painting, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to validate player painting: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    public void sellPainting(String token, String paintingName, AbstractCanvasData paintingData, Consumer<PaintingsResponse> successConsumer, Consumer<GalleryError> errorConsumer) {
        this.poolExecutor.execute(() -> {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            try {
                SaleRequest request = new SaleRequest(paintingName, paintingData);
                URL saleUri = GalleryConnection.getUri(PAINTINGS_ENDPOINT);
                PaintingsResponse response = GalleryConnection.makeRequest(saleUri, "POST", PaintingsResponse.class, token, request);
                executor.m_18689_(() -> successConsumer.accept(response));
            }
            catch (GalleryException e) {
                ZetterGallery.LOG.error(String.format("Unable to sell player painting, Gallery returned error: [%d] %s", e.getCode(), e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(e.getCode(), e.getMessage())));
            }
            catch (Exception e) {
                ZetterGallery.LOG.error(String.format("Unable to sell player painting: %s", e.getMessage()));
                executor.m_18689_(() -> errorConsumer.accept(new GalleryError(0, e.getMessage())));
            }
        });
    }

    protected static URL getUri(String endpoint) throws MalformedURLException {
        return GalleryConnection.getUri(endpoint, null);
    }

    protected static URL getUri(String endpoint, @Nullable Map<String, String> queryMap) throws MalformedURLException {
        Object query = "";
        if (queryMap != null && !queryMap.isEmpty()) {
            Vector queryElements = new Vector();
            queryMap.forEach((key, value) -> queryElements.add(key + "=" + value));
            query = "?" + String.join((CharSequence)"&", queryElements);
        }
        if (ZetterGallery.DEBUG_LOCALHOST) {
            return new URL("http://localhost:3100/v1/" + endpoint + (String)query);
        }
        return new URL("https://api.zetter.gallery/v1/" + endpoint + (String)query);
    }

    protected static <T> T makeRequest(URL uri, String method, Class<T> classOfT, @Nullable String token, @Nullable Object input) throws IOException, GalleryException {
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        if (token != null) {
            connection.setRequestProperty("Authorization", "Bearer " + token);
        }
        connection.setRequestMethod(method);
        GalleryConnection.prepareRequest(connection);
        if (method.equals("POST") && input != null) {
            GalleryConnection.writeRequest(connection, input);
        } else {
            connection.connect();
        }
        StringBuilder responseBody = new StringBuilder();
        if (connection.getResponseCode() < 200 || connection.getResponseCode() >= 300) {
            GenericMessageResponse errorResponse;
            Scanner scanner = new Scanner(connection.getErrorStream());
            while (scanner.hasNext()) {
                responseBody.append(scanner.nextLine());
            }
            scanner.close();
            connection.disconnect();
            try {
                errorResponse = (GenericMessageResponse)GSON.fromJson(responseBody.toString(), GenericMessageResponse.class);
            }
            catch (JsonSyntaxException exception) {
                throw new GalleryException(connection.getResponseCode(), connection.getResponseMessage());
            }
            throw new GalleryException(connection.getResponseCode(), errorResponse.message);
        }
        Scanner scanner = new Scanner(connection.getInputStream());
        while (scanner.hasNext()) {
            responseBody.append(scanner.nextLine());
        }
        scanner.close();
        connection.disconnect();
        return (T)GSON.fromJson(responseBody.toString(), classOfT);
    }

    private static void prepareRequest(HttpURLConnection connection) {
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("Accept", "application/json");
    }

    private static void writeRequest(HttpURLConnection connection, Object input) throws IOException {
        String jsonInput = GSON.toJson(input);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setRequestProperty("Content-Length", String.valueOf(jsonInput.length()));
        OutputStream stream = connection.getOutputStream();
        stream.write(jsonInput.getBytes(StandardCharsets.UTF_8));
        stream.close();
    }
}

