/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.http.dto;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;

public class PaintingsResponse {
    public Map<String, Vector<PaintingItem>> feeds;
    public CycleInfo cycleInfo;

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.getDecoder().decode(json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.getEncoder().encodeToString(src));
        }
    }

    public static class CycleInfo {
        public int incrementId;
        public String seed;
        public Date startsAt;
        public Date endsAt;

        public CycleInfo(int incrementId, String seed, Date startsAt, Date endsAt) {
            this.incrementId = incrementId;
            this.seed = seed;
            this.startsAt = startsAt;
            this.endsAt = endsAt;
        }
    }

    public static class Author {
        public UUID uuid;
        public String nickname;

        public Author(UUID uuid, String nickname) {
            this.uuid = uuid;
            this.nickname = nickname;
        }
    }

    public static class PaintingItem {
        public UUID uuid;
        public String name;
        public Author author;
        public int resolution;
        public int sizeH;
        public int sizeW;
        @JsonAdapter(value=ByteArrayToBase64TypeAdapter.class)
        public byte[] color;
        public int price;

        public PaintingItem(UUID uuid, String name, Author author, byte[] color, int resolution, int sizeH, int sizeW, int price) {
            this.uuid = uuid;
            this.name = name;
            this.author = author;
            this.color = color;
            this.resolution = resolution;
            this.sizeH = sizeH;
            this.sizeW = sizeW;
            this.price = price;
        }
    }
}

