/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.http.dto;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Base64;
import me.dantaeusb.zetter.storage.AbstractCanvasData;

public class SaleRequest {
    public String name;
    public int resolution;
    public int sizeH;
    public int sizeW;
    @JsonAdapter(value=ByteArrayToBase64TypeAdapter.class)
    public byte[] color;

    public SaleRequest(String name, AbstractCanvasData paintingData) {
        int resolution = paintingData.getResolution().getNumeric();
        this.name = name;
        this.resolution = resolution;
        this.sizeH = paintingData.getHeight() / resolution;
        this.sizeW = paintingData.getWidth() / resolution;
        this.color = this.extractColorData(paintingData);
    }

    private byte[] extractColorData(AbstractCanvasData paintingData) {
        int paintingSize = paintingData.getHeight() * paintingData.getWidth();
        ByteBuffer inColor = paintingData.getColorDataBuffer();
        ByteBuffer outColor = ByteBuffer.allocate(inColor.rewind().remaining());
        for (int i = 0; i < paintingSize; ++i) {
            outColor.putInt(Integer.rotateLeft(inColor.getInt(i * 4), 8));
        }
        return outColor.array();
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.getDecoder().decode(json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.getEncoder().encodeToString(src));
        }
    }
}

